/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.capability.SoulConsumerProvider;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.INameable;
import ovh.corail.tombstone.item.ITab;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.registry.ModEnchantments;

public class ItemGeneric
extends Item
implements IDisableable,
INameable,
ITab {
    protected final String name;
    private boolean hasEffect = false;
    private boolean defaultInfo = false;
    private boolean isCraftingIngredient = false;
    private boolean canCombine = false;
    private boolean forceSoulbound = false;
    private boolean isBeta = false;
    private final BooleanSupplier supplierEnabled;
    protected static final String ENCHANT_NBT_BOOL = "enchant";

    public ItemGeneric(String name) {
        this(name, ItemGeneric.getBuilder(), () -> true);
    }

    public ItemGeneric(String name, BooleanSupplier supplierEnabled) {
        this(name, ItemGeneric.getBuilder(), supplierEnabled);
    }

    public ItemGeneric(String name, Item.Properties builder) {
        this(name, builder, () -> true);
    }

    public ItemGeneric(String name, Item.Properties builder, BooleanSupplier supplierEnabled) {
        super(builder);
        this.name = name;
        this.supplierEnabled = supplierEnabled;
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
        if (this.isEnabled()) {
            toAdd.m_246342_(new ItemStack((ItemLike)this));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.supplierEnabled.getAsBoolean();
    }

    public ItemGeneric withEffect() {
        this.hasEffect = true;
        return this;
    }

    public ItemGeneric withDefaultInfo() {
        this.defaultInfo = true;
        return this;
    }

    public ItemGeneric withCraftingInfo() {
        this.isCraftingIngredient = true;
        return this;
    }

    public ItemGeneric withCombineInfo() {
        this.canCombine = true;
        return this;
    }

    public ItemGeneric withSoulboundInfo() {
        this.forceSoulbound = true;
        return this;
    }

    public ItemGeneric withBetaInfo() {
        this.isBeta = true;
        return this;
    }

    public boolean m_5812_(ItemStack stack) {
        return this.hasEffect || NBTStackHelper.getBoolean(stack, ENCHANT_NBT_BOOL);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (this.canCombine) {
            tooltip.add((Component)LangKey.MESSAGE_COMBINE_IN_INVENTORY.getText(StyleType.TOOLTIP_COMBINE, new Object[0]));
        }
        if (this.isCraftingIngredient) {
            tooltip.add((Component)LangKey.MESSAGE_CRAFTING_INGREDIENT.getText(StyleType.TOOLTIP_ITEM, new Object[0]));
        }
        if (Helper.canShowTooltip(level)) {
            if (this.defaultInfo) {
                this.addItemDesc(tooltip);
                this.addItemUse(tooltip);
            }
            this.addTooltipInfo(stack, level, tooltip);
        } else {
            this.addInfo(tooltip, LangKey.TOOLTIP_MORE_INFO, new Object[0]);
        }
        super.m_7373_(stack, level, tooltip, flag);
        if (this.forceSoulbound) {
            tooltip.add(ModEnchantments.soulbound.m_44700_(1));
        }
        stack.getCapability(SoulConsumerProvider.CAP_SOUL_CONSUMER, null).ifPresent(soulConsumer -> {
            int corruptionLevel = soulConsumer.getCorruptionLevel(stack);
            if (corruptionLevel > 0) {
                tooltip.add((Component)LangKey.TOOLTIP_CORRUPTION.getText(StyleType.COLOR_RED, new Object[]{corruptionLevel}));
            }
        });
        if (this.isBeta) {
            tooltip.add((Component)LangKey.TOOLTIP_BETA.getText(StyleType.TOOLTIP_IN_BETA, new Object[0]));
        }
        if (!this.isEnabled()) {
            this.addWarn(tooltip, LangKey.MESSAGE_DISABLED, new Object[0]);
        }
    }

    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        if (this.forceSoulbound && enchantment == ModEnchantments.soulbound) {
            return 1;
        }
        return super.getEnchantmentLevel(stack, enchantment);
    }

    public String m_5524_() {
        return "tombstone.item." + this.name;
    }

    public String m_5671_(ItemStack stack) {
        return this.m_5524_();
    }

    public void addPerkInfo(List<Component> tooltip, Perk perk, int level) {
        tooltip.add((Component)perk.getTranslation().m_6879_().m_130946_(" " + level).m_130948_(StyleType.TOOLTIP_BONUS));
    }

    public void addEffectInfo(List<Component> tooltip, MobEffect effect) {
        MutableComponent description;
        TranslatableContents contents;
        String key;
        Component displayName = effect.m_19482_();
        ComponentContents componentContents = displayName.m_214077_();
        if (componentContents instanceof TranslatableContents && !(key = "description." + (contents = (TranslatableContents)componentContents).m_237508_()).equals((description = Component.m_237115_((String)key)).getString())) {
            tooltip.add((Component)description.m_130948_(StyleType.EFFECT_DESCRIPTION));
        }
    }

    public void addItemDesc(List<Component> tooltip) {
        this.addItemDesc(tooltip, "", new Object[0]);
    }

    public void addItemDesc(List<Component> tooltip, String id, Object ... format) {
        tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".desc" + id), (Object[])format).m_6270_(StyleType.TOOLTIP_DESC));
    }

    public void addItemUse(List<Component> tooltip) {
        this.addItemUse(tooltip, "", new Object[0]);
    }

    public void addItemUse(List<Component> tooltip, String id, Object ... format) {
        tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".use" + id), (Object[])format).m_6270_(StyleType.TOOLTIP_USE));
    }

    public void addItemUse(List<Component> tooltip, LangKey langKey, Object ... format) {
        tooltip.add((Component)langKey.getText(StyleType.TOOLTIP_USE, format));
    }

    public void addInfo(List<Component> tooltip, String key, Object ... format) {
        tooltip.add((Component)Component.m_237110_((String)key, (Object[])format).m_6270_(StyleType.INFO));
    }

    public void addInfo(List<Component> tooltip, LangKey langKey, Object ... format) {
        tooltip.add((Component)langKey.getText(StyleType.INFO, format));
    }

    public void addWarn(List<Component> tooltip, LangKey langKey, Object ... format) {
        tooltip.add((Component)langKey.getText(StyleType.COLOR_RED, format));
    }

    public void addItemDistance(List<Component> tooltip, Location location) {
        Player player = ModTombstone.PROXY.getClientPlayer();
        if (player != null && !location.isOrigin()) {
            BlockPos pos = player.m_20183_();
            tooltip.add((Component)LangKey.MESSAGE_DISTANCE.getText(ChatFormatting.BLUE, new Object[]{(int)Helper.getDistance((Vec3i)location.getPos(), (Vec3i)pos)}));
        }
    }

    public void addItemPosition(List<Component> tooltip, Location location) {
        Player player = ModTombstone.PROXY.getClientPlayer();
        if (player != null && !location.isOrigin()) {
            BlockPos pos = player.m_20183_();
            tooltip.add((Component)LangKey.MESSAGE_DISTANCE.getText(ChatFormatting.BLUE, new Object[]{(int)Helper.getDistance((Vec3i)location.getPos(), (Vec3i)pos)}).m_130946_(" ").m_7220_((Component)LangKey.MESSAGE_POSITION.getText(location.x, location.y, location.z, location.getDimString())));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.m_150942_((ItemStack)oldStack, (ItemStack)newStack);
    }

    public String getCreatorModId(ItemStack itemStack) {
        return "tombstone";
    }

    protected static Item.Properties getBuilder() {
        return new Item.Properties();
    }
}

