/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.blowguns.platform;

import forge.com.cursee.blowguns.Blowguns;
import forge.com.cursee.blowguns.BlowgunsForge;
import forge.com.cursee.blowguns.core.registry.ModItems;
import forge.com.cursee.blowguns.core.world.item.DartPouchItem;
import forge.com.cursee.blowguns.core.world.item.crafting.TippedDartRecipe;
import forge.com.cursee.blowguns.platform.services.IPlatformHelper;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import top.theillusivec4.curios.api.CuriosApi;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public String getGameDirectory() {
        return FMLPaths.GAMEDIR.get().toString();
    }

    @Override
    public boolean isClientSide() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    @Override
    public CreativeModeTab.Builder createTabBuilder() {
        return CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256731_});
    }

    @Override
    public <T extends Entity> EntityType.Builder<T> createEntityType(BiFunction<EntityType<T>, Level, T> constructor, MobCategory category) {
        return EntityType.Builder.m_20704_(constructor::apply, (MobCategory)category);
    }

    @Override
    public <E extends Entity, T extends EntityType<E>, R extends EntityRenderer<E>> void registerEntityRenderer(T entityType, Function<EntityRendererProvider.Context, R> entityRendererConstructor) {
        EntityRenderers.m_174036_(entityType, entityRendererConstructor::apply);
    }

    @Override
    public void registerTippedDartItemColoring() {
        BlowgunsForge.EVENT_BUS.addListener(event -> event.register((stack, i) -> i == 0 ? PotionUtils.m_43575_((ItemStack)stack) : -1, new ItemLike[]{ModItems.TIPPED_DART}));
    }

    @Override
    public void registerTippedDartRecipeSerializer() {
        BlowgunsForge.EVENT_BUS.addListener(event -> {
            if (event.getRegistryKey() != Registries.f_256764_) {
                return;
            }
            event.register(Registries.f_256764_, recipeSerializerRegisterHelper -> recipeSerializerRegisterHelper.register(Blowguns.identifier("crafting_special_tipped_dart"), (Object)new SimpleCraftingRecipeSerializer(TippedDartRecipe::new)));
        });
    }

    @Override
    public ItemStack getDartFromAdditionalSlot(LivingEntity entity) {
        AtomicReference<ItemStack> atomicCopy = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(iCuriosItemHandler -> iCuriosItemHandler.findFirstCurio(ModItems.DART_POUCH).ifPresent(slotResult -> {
            if (slotResult.stack().m_41720_() instanceof DartPouchItem) {
                Optional<ItemStack> optional = DartPouchItem.removeOne(slotResult.stack());
                optional.ifPresent(atomicCopy::set);
                DartPouchItem.add(slotResult.stack(), (ItemStack)atomicCopy.get());
            }
        }));
        return atomicCopy.get();
    }

    @Override
    public void removeDartFromAdditionalSlot(LivingEntity entity) {
        AtomicReference<ItemStack> atomicCopy = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(iCuriosItemHandler -> iCuriosItemHandler.findFirstCurio(ModItems.DART_POUCH).ifPresent(slotResult -> {
            if (slotResult.stack().m_41720_() instanceof DartPouchItem) {
                Optional<ItemStack> optional = DartPouchItem.removeOne(slotResult.stack());
                optional.ifPresent(stack -> {
                    block3: {
                        block2: {
                            if (!(entity instanceof Player)) break block2;
                            Player player = (Player)entity;
                            if (player.m_150110_().f_35937_) break block3;
                        }
                        stack.m_41764_(stack.m_41613_() - 1);
                    }
                    atomicCopy.set((ItemStack)stack);
                });
                DartPouchItem.add(slotResult.stack(), (ItemStack)atomicCopy.get());
            }
        }));
    }

    @Override
    public boolean hasDartPouchInAdditionalSlot(LivingEntity entity) {
        AtomicBoolean foundPouch = new AtomicBoolean(false);
        CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(iCuriosItemHandler -> iCuriosItemHandler.findFirstCurio(ModItems.DART_POUCH).ifPresent(slotResult -> foundPouch.set(true)));
        return foundPouch.get();
    }
}

