/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.blowguns.core.world.item;

import forge.com.cursee.blowguns.core.registry.ModEnchantments;
import forge.com.cursee.blowguns.core.registry.ModItems;
import forge.com.cursee.blowguns.core.tag.ModItemTags;
import forge.com.cursee.blowguns.core.world.entity.projectile.Dart;
import forge.com.cursee.blowguns.core.world.item.DartItem;
import forge.com.cursee.blowguns.core.world.item.DartPouchItem;
import forge.com.cursee.blowguns.platform.Services;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class BlowgunItem
extends ProjectileWeaponItem {
    public static final Predicate<ItemStack> DART_ONLY = itemStack -> itemStack.m_204117_(ModItemTags.DARTS);
    private final Map<UUID, Integer> time = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> fired = new HashMap<UUID, Integer>();

    public BlowgunItem(Item.Properties properties) {
        super(properties);
    }

    public Predicate<ItemStack> m_6437_() {
        return DART_ONLY;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.m_5776_());
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack blowgunStack, int remainingUseDuration) {
        UUID entityUUID;
        block25: {
            int maxShots;
            boolean entityIsPlayer;
            block24: {
                boolean dartFromModSlotPouch;
                block27: {
                    ItemStack dartStackX;
                    ItemStack pouchStack;
                    Player player;
                    block32: {
                        block31: {
                            Optional<ItemStack> removed;
                            AtomicReference<ItemStack> dartStack;
                            AtomicInteger pouchIndex;
                            block28: {
                                AtomicBoolean dartFromInventoryPouch;
                                block26: {
                                    boolean entitySpawnsDart;
                                    super.m_5929_(level, entity, blowgunStack, remainingUseDuration);
                                    if (!entity.m_6117_()) {
                                        return;
                                    }
                                    entityUUID = entity.m_20148_();
                                    entityIsPlayer = entity instanceof Player;
                                    boolean entityIsCreativePlayer = entityIsPlayer && ((Player)entity).m_150110_().f_35937_;
                                    maxShots = EnchantmentHelper.m_44843_((Enchantment)ModEnchantments.EXTRA_BREATH, (ItemStack)entity.m_21120_(entity.m_7655_())) + 1;
                                    int timeToShoot = 15 - 5 * EnchantmentHelper.m_44843_((Enchantment)ModEnchantments.QUICK_BREATH, (ItemStack)entity.m_21120_(entity.m_7655_()));
                                    if (!this.time.containsKey(entityUUID)) {
                                        this.time.put(entityUUID, 0);
                                    } else if ((this.fired.computeIfAbsent(entityUUID, uuid -> 0) >= maxShots || this.time.computeIfAbsent(entityUUID, uuid -> 0) >= this.m_8105_(blowgunStack)) && entity instanceof Player) {
                                        Player player2 = (Player)entity;
                                        player2.m_36335_().m_41524_((Item)this, 15);
                                    }
                                    if (this.fired.computeIfAbsent(entityUUID, uuid -> 0) >= maxShots || this.time.computeIfAbsent(entityUUID, uuid -> 0) >= this.m_8105_(blowgunStack)) {
                                        entity.m_5810_();
                                        if (entityIsPlayer) {
                                            ((Player)entity).m_36335_().m_41524_((Item)this, 15);
                                        }
                                        this.fired.put(entityUUID, 0);
                                        this.time.put(entityUUID, 0);
                                    }
                                    pouchIndex = new AtomicInteger(-1);
                                    dartFromInventoryPouch = new AtomicBoolean(false);
                                    dartFromModSlotPouch = false;
                                    dartStack = new AtomicReference<ItemStack>(entity.m_6298_(blowgunStack));
                                    if (dartStack.get().m_41619_() && entity instanceof Player) {
                                        Player player3 = (Player)entity;
                                        if (!dartFromInventoryPouch.get()) {
                                            for (int i = 0; i < player3.m_150109_().f_35974_.size(); ++i) {
                                                Optional<ItemStack> removed2;
                                                ItemStack pouchStack2 = (ItemStack)player3.m_150109_().f_35974_.get(i);
                                                if (!(pouchStack2.m_41720_() instanceof DartPouchItem) || !(removed2 = DartPouchItem.removeOne(pouchStack2)).isPresent()) continue;
                                                ItemStack dart = removed2.get();
                                                dartStack.set(dart.m_41777_());
                                                DartPouchItem.add(pouchStack2, dart);
                                                dartFromInventoryPouch.set(true);
                                                player3.m_150109_().m_6596_();
                                                pouchIndex.set(i);
                                                break;
                                            }
                                        }
                                    }
                                    if (dartStack.get().m_41619_() && Services.PLATFORM.additionalSlotToCheck()) {
                                        dartStack.set(Services.PLATFORM.getDartFromAdditionalSlot(entity));
                                        dartFromModSlotPouch = !dartStack.get().m_41619_();
                                    }
                                    boolean bl = entitySpawnsDart = !dartStack.get().m_41619_() || entityIsCreativePlayer;
                                    if (!entitySpawnsDart || this.fired.computeIfAbsent(entityUUID, uuid -> 0) >= maxShots || this.time.computeIfAbsent(entityUUID, uuid -> 0) != 0 && this.time.computeIfAbsent(entityUUID, uuid -> 0) % timeToShoot != 0) break block25;
                                    level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_144090_, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
                                    if (level.f_46443_) break block24;
                                    DartItem dartItem = (DartItem)(dartStack.get().m_41720_() instanceof DartItem ? dartStack.get().m_41720_() : ModItems.DART);
                                    Dart dart = dartItem.createDart(level, dartStack.get(), entity);
                                    dart.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                                    int inaccuracy = 15 - 5 * EnchantmentHelper.m_44843_((Enchantment)ModEnchantments.FOCUSED_BREATH, (ItemStack)entity.m_21120_(entity.m_7655_()));
                                    dart.m_37251_((Entity)entity, entity.m_146909_(), entity.m_146908_(), 0.0f, 1.5f, inaccuracy);
                                    if (level.m_7967_((Entity)dart)) {
                                        this.fired.put(entityUUID, this.fired.getOrDefault(entityUUID, 0) + 1);
                                    }
                                    if (entityIsCreativePlayer) break block24;
                                    blowgunStack.m_41622_(1, entity, self -> self.m_21190_(entity.m_7655_()));
                                    if (dartFromInventoryPouch.get() || dartFromModSlotPouch) break block26;
                                    ItemStack overwrite = dartStack.get();
                                    overwrite.m_41774_(1);
                                    dartStack.set(overwrite);
                                    if (dartStack.get().m_41619_() && entityIsPlayer) {
                                        ((Player)entity).m_150109_().m_36057_(dartStack.get());
                                    }
                                    break block24;
                                }
                                if (!dartFromInventoryPouch.get() || !(entity instanceof Player)) break block27;
                                player = (Player)entity;
                                if (pouchIndex.get() != -1) break block28;
                                for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                                    ItemStack dartStackX2;
                                    ItemStack pouchStack3;
                                    block30: {
                                        block29: {
                                            Optional<ItemStack> removed3;
                                            pouchStack3 = (ItemStack)player.m_150109_().f_35974_.get(i);
                                            if (!(pouchStack3.m_41720_() instanceof DartPouchItem) || !(removed3 = DartPouchItem.removeOne(pouchStack3)).isPresent()) continue;
                                            dartStackX2 = removed3.get();
                                            dartStack.set(dartStackX2.m_41777_());
                                            if (!(entity instanceof Player)) break block29;
                                            Player p = (Player)entity;
                                            if (p.m_150110_().f_35937_) break block30;
                                        }
                                        dartStackX2.m_41774_(1);
                                    }
                                    DartPouchItem.add(pouchStack3, dartStackX2);
                                    player.m_150109_().m_6596_();
                                    break block24;
                                }
                                break block24;
                            }
                            pouchStack = (ItemStack)player.m_150109_().f_35974_.get(pouchIndex.get());
                            if (!(pouchStack.m_41720_() instanceof DartPouchItem) || !(removed = DartPouchItem.removeOne(pouchStack)).isPresent()) break block24;
                            dartStackX = removed.get();
                            dartStack.set(dartStackX.m_41777_());
                            if (!(entity instanceof Player)) break block31;
                            Player p = (Player)entity;
                            if (p.m_150110_().f_35937_) break block32;
                        }
                        dartStackX.m_41774_(1);
                    }
                    DartPouchItem.add(pouchStack, dartStackX);
                    player.m_150109_().m_6596_();
                    break block24;
                }
                if (dartFromModSlotPouch) {
                    Services.PLATFORM.removeDartFromAdditionalSlot(entity);
                }
            }
            if (this.fired.get(entityUUID) >= maxShots || this.time.get(entityUUID) >= this.m_8105_(blowgunStack)) {
                entity.m_5810_();
                if (entityIsPlayer) {
                    ((Player)entity).m_36335_().m_41524_((Item)this, 15);
                }
                this.fired.put(entityUUID, 0);
                this.time.put(entityUUID, 0);
            }
        }
        this.time.put(entityUUID, this.time.get(entityUUID) + 1);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeCharged) {
        super.m_5551_(stack, level, entity, timeCharged);
        this.time.remove(entity.m_20148_());
        this.fired.remove(entity.m_20148_());
        if (entity instanceof Player) {
            ((Player)entity).m_36335_().m_41524_((Item)this, 15);
        }
    }

    public int m_6615_() {
        return 8;
    }

    public int m_8105_(ItemStack stack) {
        return 200;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.TOOT_HORN;
    }

    public int m_6473_() {
        return 22;
    }
}

