/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.blowguns.core.world.entity.projectile;

import com.google.common.collect.Sets;
import fabric.com.cursee.blowguns.core.registry.ModEntities;
import fabric.com.cursee.blowguns.core.registry.ModItems;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3966;
import net.minecraft.class_7923;

public class Dart
extends class_1665 {
    private static final int EXPOSED_POTION_DECAY_TIME = 600;
    private static final int NO_EFFECT_COLOR = -1;
    private static final class_2940<Integer> ID_EFFECT_COLOR = class_2945.method_12791(Dart.class, (class_2941)class_2943.field_13327);
    private static final byte EVENT_POTION_PUFF = 0;
    private class_1842 potion;
    private final Set<class_1293> effects;
    private boolean fixedColor;

    public Dart(class_1299<? extends class_1665> entityType, class_1937 level) {
        super(entityType, level);
        this.method_7438(1.0);
        this.potion = class_1847.field_8984;
        this.effects = Sets.newHashSet();
    }

    public Dart(double x, double y, double z, class_1937 level) {
        super(ModEntities.DART, x, y, z, level);
        this.method_7438(1.0);
        this.potion = class_1847.field_8984;
        this.effects = Sets.newHashSet();
    }

    public Dart(class_1309 livingEntity, class_1937 level) {
        super(ModEntities.DART, livingEntity, level);
        this.method_7438(1.0);
        this.potion = class_1847.field_8984;
        this.effects = Sets.newHashSet();
    }

    public Dart(class_1937 level, class_1309 livingEntity) {
        this(livingEntity, level);
    }

    protected class_1799 method_7445() {
        if (this.effects.isEmpty() && this.potion == class_1847.field_8984) {
            return new class_1799((class_1935)ModItems.DART);
        }
        class_1799 itemstack = new class_1799((class_1935)ModItems.TIPPED_DART);
        class_1844.method_8061((class_1799)itemstack, (class_1842)this.potion);
        class_1844.method_8056((class_1799)itemstack, this.effects);
        if (this.fixedColor) {
            itemstack.method_7948().method_10569("CustomPotionColor", this.getColor());
        }
        return itemstack;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ID_EFFECT_COLOR, (Object)-1);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (this.potion != class_1847.field_8984) {
            compound.method_10582("Potion", class_7923.field_41179.method_10221((Object)this.potion).toString());
        }
        if (this.fixedColor) {
            compound.method_10569("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            class_2499 listtag = new class_2499();
            for (class_1293 mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.method_5582(new class_2487()));
            }
            compound.method_10566("CustomPotionEffects", (class_2520)listtag);
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10573("Potion", 8)) {
            this.potion = class_1844.method_8057((class_2487)compound);
        }
        for (class_1293 mobeffectinstance : class_1844.method_8060((class_2487)compound)) {
            this.addEffect(mobeffectinstance);
        }
        if (compound.method_10573("Color", 99)) {
            this.setFixedColor(compound.method_10550("Color"));
        } else {
            this.updateColor();
        }
    }

    protected void method_7450(class_1309 living) {
        super.method_7450(living);
        class_1297 entity = this.method_37225();
        for (class_1293 mobeffectinstance : this.potion.method_8049()) {
            living.method_37222(new class_1293(mobeffectinstance.method_5579(), Math.max(mobeffectinstance.method_48558(p_268168_ -> p_268168_ / 8), 1), mobeffectinstance.method_5578(), mobeffectinstance.method_5591(), mobeffectinstance.method_5581()), entity);
        }
        if (!this.effects.isEmpty()) {
            for (class_1293 mobeffectinstance1 : this.effects) {
                living.method_37222(mobeffectinstance1, entity);
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            if (this.field_7588) {
                if (this.field_7576 % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.field_7588 && this.field_7576 != 0 && !this.effects.isEmpty() && this.field_7576 >= 600) {
            this.method_37908().method_8421((class_1297)this, (byte)0);
            this.potion = class_1847.field_8984;
            this.effects.clear();
            this.field_6011.method_12778(ID_EFFECT_COLOR, (Object)-1);
        }
        if (this.field_7588 && this.field_7576 >= 100) {
            this.method_31472();
        }
    }

    public void method_5711(byte id) {
        if (id == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11226, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), d0, d1, d2);
                }
            }
        } else {
            super.method_5711(id);
        }
    }

    private void makeParticle(int particleAmount) {
        int color = this.getColor();
        if (color != -1 && particleAmount > 0) {
            double d0 = (double)(color >> 16 & 0xFF) / 255.0;
            double d1 = (double)(color >> 8 & 0xFF) / 255.0;
            double d2 = (double)(color >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < particleAmount; ++j) {
                this.method_37908().method_8406((class_2394)class_2398.field_11226, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(ID_EFFECT_COLOR);
    }

    public static int getCustomColor(class_1799 stack) {
        class_2487 compoundtag = stack.method_7969();
        return compoundtag != null && compoundtag.method_10573("CustomPotionColor", 99) ? compoundtag.method_10550("CustomPotionColor") : -1;
    }

    private void updateColor() {
        this.fixedColor = false;
        if (this.potion == class_1847.field_8984 && this.effects.isEmpty()) {
            this.field_6011.method_12778(ID_EFFECT_COLOR, (Object)-1);
        } else {
            this.field_6011.method_12778(ID_EFFECT_COLOR, (Object)class_1844.method_8055((Collection)class_1844.method_8059((class_1842)this.potion, this.effects)));
        }
    }

    private void setFixedColor(int fixedColor) {
        this.fixedColor = true;
        this.field_6011.method_12778(ID_EFFECT_COLOR, (Object)fixedColor);
    }

    public void addEffect(class_1293 effectInstance) {
        this.effects.add(effectInstance);
        this.method_5841().method_12778(ID_EFFECT_COLOR, (Object)class_1844.method_8055((Collection)class_1844.method_8059((class_1842)this.potion, this.effects)));
    }

    public void setEffectsFromItem(class_1799 stack) {
        if (stack.method_31574(ModItems.TIPPED_DART)) {
            int i;
            this.potion = class_1844.method_8063((class_1799)stack);
            List collection = class_1844.method_8068((class_1799)stack);
            if (!collection.isEmpty()) {
                for (class_1293 mobeffectinstance : collection) {
                    this.effects.add(new class_1293(mobeffectinstance));
                }
            }
            if ((i = Dart.getCustomColor(stack)) == -1) {
                this.updateColor();
            } else {
                this.setFixedColor(i);
            }
        } else if (stack.method_31574(ModItems.DART)) {
            this.potion = class_1847.field_8984;
            this.effects.clear();
            this.field_6011.method_12778(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    protected void method_7454(class_3966 result) {
        super.method_7454(result);
    }
}

