/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.client.config.gui;

import dev.architectury.platform.Platform;
import io.github.jamalam360.jamlib.client.config.gui.ConfigScreen;
import io.github.jamalam360.jamlib.client.config.gui.SelectionList;
import io.github.jamalam360.jamlib.client.config.gui.SelectionListEntry;
import io.github.jamalam360.jamlib.config.ConfigManager;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SelectConfigScreen
extends Screen {
    private final String modId;
    private final Screen parent;

    public SelectConfigScreen(Screen parent, String modId) {
        super(SelectConfigScreen.createTitle(modId));
        this.parent = parent;
        this.modId = modId;
    }

    private static Component createTitle(String modId) {
        String translationKey = "config." + modId + ".title";
        if (I18n.m_118936_((String)translationKey)) {
            return Component.m_237115_((String)translationKey);
        }
        return Component.m_237110_((String)"config.jamlib.selection_screen_title", (Object[])new Object[]{Platform.getMod((String)modId).getName()});
    }

    protected void m_7856_() {
        super.m_7856_();
        ConfigSelectionList list = new ConfigSelectionList(this.f_96541_, this.f_96543_, this.f_96544_, 25);
        ConfigManager.MANAGERS.values().stream().filter(m -> m.getModId().equals(this.modId)).forEach(list::addEntry);
        this.m_142416_((GuiEventListener)list);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> Objects.requireNonNull(this.f_96541_).m_91152_(this.parent)).m_252794_(this.f_96543_ / 2 - 75, this.f_96544_ - 29).m_253046_(150, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(graphics, mouseX, mouseY, delta);
        graphics.m_280653_(Minecraft.m_91087_().f_91062_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
    }

    private static class ConfigSelectionList
    extends SelectionList {
        public ConfigSelectionList(Minecraft minecraft, int width, int height, int itemHeight) {
            super(minecraft, width, height, itemHeight);
        }

        private void addEntry(ConfigManager<?> manager) {
            List tooltip = null;
            String tooltipTranslationKey = ConfigScreen.createTranslationKey(manager.getModId(), manager.getConfigName(), "tooltip");
            if (I18n.m_118936_((String)tooltipTranslationKey)) {
                tooltip = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237115_((String)tooltipTranslationKey), 200);
            }
            this.m_7085_((AbstractSelectionList.Entry)new SelectionListEntry(ConfigScreen.createTitle(manager), tooltip, List.of(Button.m_253074_((Component)Component.m_237115_((String)"config.jamlib.open"), b -> this.f_93386_.m_91152_(new ConfigScreen(manager, this.f_93386_.f_91080_))).m_252794_(this.f_93388_ - 160, this.f_93389_ - 28).m_253046_(150, 20).m_253136_())));
        }
    }
}

