/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.client.config.gui;

import dev.architectury.platform.Platform;
import io.github.jamalam360.jamlib.JamLib;
import io.github.jamalam360.jamlib.client.config.gui.entry.ConfigEntry;
import io.github.jamalam360.jamlib.client.gui.SpriteButton;
import io.github.jamalam360.jamlib.client.gui.WidgetList;
import io.github.jamalam360.jamlib.config.ConfigExtensions;
import io.github.jamalam360.jamlib.config.ConfigManager;
import io.github.jamalam360.jamlib.config.HiddenInGui;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ConfigScreen<T>
extends Screen {
    protected final ConfigManager<T> manager;
    private final Screen parent;
    private final List<ConfigEntry<T, ?>> entries;
    private WidgetList widgetList;
    private Button doneButton;

    public ConfigScreen(ConfigManager<T> manager, Screen parent) {
        super(ConfigScreen.createTitle(manager));
        this.manager = manager;
        this.parent = parent;
        this.entries = new ArrayList();
    }

    @ApiStatus.Internal
    public static String createTranslationKey(String modId, String configName, String path) {
        if (modId.equals(configName)) {
            return "config." + modId + "." + path;
        }
        return "config." + modId + "." + configName + "." + path;
    }

    protected static Component createTitle(ConfigManager<?> manager) {
        String translationKey = ConfigScreen.createTranslationKey(manager.getModId(), manager.getConfigName(), "title");
        if (I18n.m_118936_((String)translationKey)) {
            return Component.m_237115_((String)translationKey);
        }
        return Component.m_237113_((String)Platform.getMod((String)manager.getModId()).getName());
    }

    protected void m_7856_() {
        super.m_7856_();
        this.widgetList = new WidgetList(this.f_96541_, this.f_96543_, this.f_96544_);
        if (this.entries.isEmpty()) {
            for (Field field : this.manager.getConfigClass().getFields()) {
                if (field.isAnnotationPresent(HiddenInGui.class)) continue;
                this.entries.add(ConfigEntry.createFromField(this.manager.getModId(), this.manager.getConfigName(), field));
            }
        }
        for (ConfigEntry configEntry : this.entries) {
            this.widgetList.addWidgetGroup(configEntry.createWidgets(this.f_96543_));
        }
        this.m_142416_((GuiEventListener)this.widgetList);
        T t = this.manager.get();
        if (t instanceof ConfigExtensions) {
            ConfigExtensions ext = (ConfigExtensions)t;
            List<ConfigExtensions.Link> list = ext.getLinks();
            for (int i = 0; i < list.size(); ++i) {
                ConfigExtensions.Link link = list.get(i);
                this.m_142416_((GuiEventListener)new SpriteButton(this.f_96543_ - 30 - 28 * i, 5, 20, 20, link.getTooltip().m_6881_(), link.getTexture(), 16, 16, button -> {
                    try {
                        Util.m_137581_().m_137648_(link.getUrl().toURI());
                    }
                    catch (Exception e) {
                        JamLib.LOGGER.error("Failed to open link", (Throwable)e);
                    }
                }));
            }
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> {
            this.manager.reloadFromDisk();
            Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
        }).m_252794_(this.f_96543_ / 2 - 154, this.f_96544_ - 28).m_253046_(150, 20).m_253136_());
        this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            if (this.hasChanges()) {
                this.manager.save();
            }
            Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
        }).m_252794_(this.f_96543_ / 2 + 4, this.f_96544_ - 28).m_253046_(150, 20).m_253136_());
        this.m_142416_((GuiEventListener)new SpriteButton(7, 7, 20, 20, Component.m_237115_((String)"config.jamlib.edit_manually"), JamLib.id("textures/gui/writable_book.png"), 16, 16, button -> {
            if (this.hasChanges()) {
                this.manager.save();
            }
            Util.m_137581_().m_137644_(Platform.getConfigFolder().resolve(this.manager.getConfigName() + ".json5").toFile());
            Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
        }));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(graphics, mouseX, mouseY, delta);
        graphics.m_280653_(Minecraft.m_91087_().f_91062_, this.f_96539_, this.f_96543_ / 2, 12, 0xFFFFFF);
    }

    private boolean canExit() {
        return this.entries.stream().allMatch(ConfigEntry::isValid);
    }

    private boolean hasChanges() {
        return this.entries.stream().anyMatch(ConfigEntry::hasChanged);
    }

    public void m_86600_() {
        super.m_86600_();
        boolean canExit = this.canExit();
        if (this.doneButton.f_93623_ != canExit) {
            this.doneButton.f_93623_ = canExit;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            ConfigEntry<T, ?> entry = this.entries.get(i);
            List<AbstractWidget> widgets = entry.getNewWidgets(this.f_96543_);
            if (widgets == null) continue;
            this.widgetList.updateWidgetGroup(i, widgets);
        }
    }
}

