/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.face;

import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.blockinformation.BlockInformation;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class FaceRegion {
    private final Direction face;
    private final IBlockInformation blockInformation;
    private final boolean isEdge;
    private float minX;
    private float minY;
    private float minZ;
    private float maxX;
    private float maxY;
    private float maxZ;

    public static FaceRegion createFrom3DObjectWithFacing(Vec3 start, Vec3 end, Direction facing, IBlockInformation blockInformation, boolean isEdge) {
        return new FaceRegion(facing, blockInformation, isEdge, (float)(facing.m_122429_() == 0 ? start.m_7096_() : (facing.m_122429_() == 1 ? Math.max(start.m_7096_(), end.m_7096_()) : Math.min(start.m_7096_(), end.m_7096_()))), (float)(facing.m_122430_() == 0 ? start.m_7098_() : (facing.m_122430_() == 1 ? Math.max(start.m_7098_(), end.m_7098_()) : Math.min(start.m_7098_(), end.m_7098_()))), (float)(facing.m_122431_() == 0 ? start.m_7094_() : (facing.m_122431_() == 1 ? Math.max(start.m_7094_(), end.m_7094_()) : Math.min(start.m_7094_(), end.m_7094_()))), (float)(facing.m_122429_() == 0 ? end.m_7096_() : (facing.m_122429_() == 1 ? Math.max(start.m_7096_(), end.m_7096_()) : Math.min(start.m_7096_(), end.m_7096_()))), (float)(facing.m_122430_() == 0 ? end.m_7098_() : (facing.m_122430_() == 1 ? Math.max(start.m_7098_(), end.m_7098_()) : Math.min(start.m_7098_(), end.m_7098_()))), (float)(facing.m_122431_() == 0 ? end.m_7094_() : (facing.m_122431_() == 1 ? Math.max(start.m_7094_(), end.m_7094_()) : Math.min(start.m_7094_(), end.m_7094_()))));
    }

    public FaceRegion(Direction facingDirection, float centerX, float centerY, float centerZ, BlockInformation blockInformation, boolean isEdgeFace) {
        this.face = facingDirection;
        this.blockInformation = blockInformation;
        this.isEdge = isEdgeFace;
        this.minX = centerX;
        this.minY = centerY;
        this.minZ = centerZ;
        this.maxX = centerX;
        this.maxY = centerY;
        this.maxZ = centerZ;
    }

    public FaceRegion(Direction face, IBlockInformation blockInformation, boolean isEdge, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.face = face;
        this.blockInformation = blockInformation;
        this.isEdge = isEdge;
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public IBlockInformation getBlockInformation() {
        return this.blockInformation;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMinY() {
        return this.minY;
    }

    public float getMinZ() {
        return this.minZ;
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public float getMaxZ() {
        return this.maxZ;
    }

    public boolean isEdge() {
        return this.isEdge;
    }

    public Direction getFace() {
        return this.face;
    }

    public Vector3f maxVector() {
        return new Vector3f(this.maxX, this.maxY, this.maxZ);
    }

    public Vector3f minVector() {
        return new Vector3f(this.minX, this.minY, this.minZ);
    }

    public boolean extend(FaceRegion faceToExtendTo) {
        if (faceToExtendTo.blockInformation != this.blockInformation) {
            return false;
        }
        switch (this.face) {
            case DOWN: 
            case UP: {
                boolean d;
                boolean a = this.maxX == faceToExtendTo.minX && this.maxZ == faceToExtendTo.maxZ && this.minZ == faceToExtendTo.minZ;
                boolean b = this.minX == faceToExtendTo.maxX && this.maxZ == faceToExtendTo.maxZ && this.minZ == faceToExtendTo.minZ;
                boolean c = this.maxZ == faceToExtendTo.minZ && this.maxX == faceToExtendTo.maxX && this.minX == faceToExtendTo.minX;
                boolean bl = d = this.minZ == faceToExtendTo.maxZ && this.maxX == faceToExtendTo.maxX && this.minX == faceToExtendTo.minX;
                if (a || b || c || d) {
                    this.minX = Math.min(faceToExtendTo.minX, this.minX);
                    this.minY = Math.min(faceToExtendTo.minY, this.minY);
                    this.minZ = Math.min(faceToExtendTo.minZ, this.minZ);
                    this.maxX = Math.max(faceToExtendTo.maxX, this.maxX);
                    this.maxY = Math.max(faceToExtendTo.maxY, this.maxY);
                    this.maxZ = Math.max(faceToExtendTo.maxZ, this.maxZ);
                    return true;
                }
                return false;
            }
            case WEST: 
            case EAST: {
                boolean d;
                boolean a = this.maxY == faceToExtendTo.minY && this.maxZ == faceToExtendTo.maxZ && this.minZ == faceToExtendTo.minZ;
                boolean b = this.minY == faceToExtendTo.maxY && this.maxZ == faceToExtendTo.maxZ && this.minZ == faceToExtendTo.minZ;
                boolean c = this.maxZ == faceToExtendTo.minZ && this.maxY == faceToExtendTo.maxY && this.minY == faceToExtendTo.minY;
                boolean bl = d = this.minZ == faceToExtendTo.maxZ && this.maxY == faceToExtendTo.maxY && this.minY == faceToExtendTo.minY;
                if (a || b || c || d) {
                    this.minX = Math.min(faceToExtendTo.minX, this.minX);
                    this.minY = Math.min(faceToExtendTo.minY, this.minY);
                    this.minZ = Math.min(faceToExtendTo.minZ, this.minZ);
                    this.maxX = Math.max(faceToExtendTo.maxX, this.maxX);
                    this.maxY = Math.max(faceToExtendTo.maxY, this.maxY);
                    this.maxZ = Math.max(faceToExtendTo.maxZ, this.maxZ);
                    return true;
                }
                return false;
            }
            case NORTH: 
            case SOUTH: {
                boolean d;
                boolean a = this.maxY == faceToExtendTo.minY && this.maxX == faceToExtendTo.maxX && this.minX == faceToExtendTo.minX;
                boolean b = this.minY == faceToExtendTo.maxY && this.maxX == faceToExtendTo.maxX && this.minX == faceToExtendTo.minX;
                boolean c = this.maxX == faceToExtendTo.minX && this.maxY == faceToExtendTo.maxY && this.minY == faceToExtendTo.minY;
                boolean bl = d = this.minX == faceToExtendTo.maxX && this.maxY == faceToExtendTo.maxY && this.minY == faceToExtendTo.minY;
                if (a || b || c || d) {
                    this.minX = Math.min(faceToExtendTo.minX, this.minX);
                    this.minY = Math.min(faceToExtendTo.minY, this.minY);
                    this.minZ = Math.min(faceToExtendTo.minZ, this.minZ);
                    this.maxX = Math.max(faceToExtendTo.maxX, this.maxX);
                    this.maxY = Math.max(faceToExtendTo.maxY, this.maxY);
                    this.maxZ = Math.max(faceToExtendTo.maxZ, this.maxZ);
                    return true;
                }
                return false;
            }
        }
        return false;
    }
}

