/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.input;

import com.communi.suggestu.scena.core.dist.Dist;
import com.communi.suggestu.scena.core.dist.DistExecutor;
import java.util.function.Supplier;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.input.ProcessingInputTracker;
import mod.chiselsandbits.network.packets.InputTrackerStatusUpdatePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;

public final class FrameBasedInputTracker {
    private static final FrameBasedInputTracker INSTANCE = new FrameBasedInputTracker();
    private final InputTracker leftMouseTracker = new InputTracker(() -> (Boolean)DistExecutor.runForDist(() -> () -> Minecraft.m_91087_().f_91066_.f_92096_.m_90857_(), () -> () -> false), () -> {
        ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new InputTrackerStatusUpdatePacket(true, true));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ProcessingInputTracker.getInstance().onStartedLeftClicking((Player)Minecraft.m_91087_().f_91074_));
    }, () -> {
        ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new InputTrackerStatusUpdatePacket(true, false));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ProcessingInputTracker.getInstance().onStoppedLeftClicking((Player)Minecraft.m_91087_().f_91074_));
    });
    private final InputTracker rightMouseTracker = new InputTracker(() -> (Boolean)DistExecutor.runForDist(() -> () -> Minecraft.m_91087_().f_91066_.f_92095_.m_90857_(), () -> () -> false), () -> {
        ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new InputTrackerStatusUpdatePacket(false, true));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ProcessingInputTracker.getInstance().onStartedRightClicking((Player)Minecraft.m_91087_().f_91074_));
    }, () -> {
        ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new InputTrackerStatusUpdatePacket(false, false));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ProcessingInputTracker.getInstance().onStoppedRightClicking((Player)Minecraft.m_91087_().f_91074_));
    });

    public static FrameBasedInputTracker getInstance() {
        return INSTANCE;
    }

    private FrameBasedInputTracker() {
    }

    public void onRenderFrame() {
        this.leftMouseTracker.tick();
        this.rightMouseTracker.tick();
    }

    private static final class InputTracker {
        private final Supplier<Boolean> isActiveChecker;
        private final Runnable onToggleOn;
        private final Runnable onToggleOff;
        private boolean isActive = false;

        private InputTracker(Supplier<Boolean> isActiveChecker, Runnable onToggleOn, Runnable onToggleOff) {
            this.isActiveChecker = isActiveChecker;
            this.onToggleOn = onToggleOn;
            this.onToggleOff = onToggleOff;
        }

        public void tick() {
            boolean newPotentialState = this.isActiveChecker.get();
            if (this.isActive && !newPotentialState) {
                this.onToggleOff.run();
                this.isActive = false;
            } else if (!this.isActive && newPotentialState) {
                this.onToggleOn.run();
                this.isActive = true;
            }
        }
    }
}

