/*
 * Decompiled with CFR 0.152.
 */
package syric.dragonseeker.item.tool;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import syric.dragonseeker.DragonseekerConfig;

public class dragonseekerGeneric
extends Item {
    private int opDist;
    private int maxDist;
    private double minPing;
    private double maxPing;
    private int minSig;
    private double pow;
    private float minVol;
    private float maxVol;
    private float minPitch;
    private float maxPitch;
    private final SoundEvent negSound;
    private final SoundEvent pingSound;
    private boolean detectsCorpses;
    private boolean detectsTame;
    private final Item repairItem;
    private final int seekerType;
    private boolean isDefault;

    public dragonseekerGeneric(int opDistIn, int maxDistIn, double minPingIn, double maxPingIn, int minSigIn, double powIn, double minVolIn, double maxVolIn, double minPitchIn, double maxPitchIn, SoundEvent negSoundIn, SoundEvent pingSoundIn, boolean detectsCorpsesIn, boolean detectsTameIn, int durabilityIn, Rarity rarityIn, Item repairItemIn, int seekerTypeIn) {
        super(new Item.Properties().m_41487_(1).m_41503_(durabilityIn).m_41497_(rarityIn));
        this.opDist = opDistIn;
        this.maxDist = maxDistIn;
        this.minPing = minPingIn;
        this.maxPing = maxPingIn;
        this.minSig = minSigIn;
        this.pow = powIn;
        this.minVol = (float)minVolIn;
        this.maxVol = (float)maxVolIn;
        this.minPitch = (float)minPitchIn;
        this.maxPitch = (float)maxPitchIn;
        this.negSound = negSoundIn;
        this.pingSound = pingSoundIn;
        this.detectsCorpses = detectsCorpsesIn;
        this.detectsTame = detectsTameIn;
        this.repairItem = repairItemIn;
        this.seekerType = seekerTypeIn;
        this.isDefault = true;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_41720_() == this.repairItem;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!world.f_46443_) {
            if (this.isDefault) {
                this.importConfig();
                this.isDefault = false;
            }
            itemstack.m_41622_(1, (LivingEntity)player, entity -> player.m_21190_(player.m_7655_()));
            double distance = this.getDistance(world, player);
            double chance = this.getPingChance(distance);
            float vol = (float)this.getPingVolume(distance);
            RandomSource random = world.f_46441_;
            double rand = random.m_188500_();
            if (rand <= chance) {
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.pingSound, SoundSource.MASTER, vol, this.maxPitch);
            } else {
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.negSound, SoundSource.MASTER, this.minVol, this.minPitch);
            }
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    private double getDistance(Level world, Player player) {
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        AABB box = new AABB(x - 300.0, -64.0, z - 300.0, x + 300.0, y + 100.0, z + 300.0);
        List listOfTargets = world.m_45976_(EntityDragonBase.class, box);
        float min = 0.0f;
        EntityDragonBase closest = null;
        for (EntityDragonBase target : listOfTargets) {
            if (!(!this.detectsCorpses && target.isModelDead() || !this.detectsTame && target.m_21824_())) {
                float distance = target.m_20270_((Entity)player);
                if (min == 0.0f || distance < min) {
                    min = distance;
                    closest = target;
                    continue;
                }
                if (!(distance >= min)) continue;
            }
            if ((this.detectsCorpses || !target.isModelDead()) && !this.detectsTame && !target.m_21824_()) continue;
        }
        if (this.seekerType == 4) {
            String s = closest != null ? Math.round(min) + ", x=" + (int)closest.m_20185_() + ", y=" + (int)closest.m_20186_() + ", z=" + (int)closest.m_20189_() : "No dragon found";
            player.m_5661_((Component)Component.m_237113_((String)s), false);
        }
        return min;
    }

    private double getPingChance(double distance) {
        double chance = distance < (double)this.opDist && distance != 0.0 ? this.maxPing : (distance > (double)this.maxDist || distance == 0.0 ? this.minPing : this.minPing + ((double)this.maxDist - distance) / (double)(this.maxDist - this.opDist) * (this.maxPing - this.minPing));
        return chance;
    }

    private double getPingVolume(double distance) {
        double vol = distance < (double)this.minSig && distance != 0.0 ? (double)this.maxVol : (distance > (double)this.maxDist || distance == 0.0 ? (double)this.minVol : (double)this.minVol + Math.pow(((double)this.maxDist - distance) / (double)(this.maxDist - this.minSig), this.pow) * (double)(this.maxVol - this.minVol));
        return vol;
    }

    private void printDistance(double distance, Level world, Player player) {
        if (!world.f_46443_) {
            int distancenew = (int)Math.round(distance);
            String s = String.valueOf(distancenew);
            player.m_5661_((Component)Component.m_237113_((String)s), false);
        }
    }

    public void importConfig() {
        if (this.seekerType == 1) {
            this.opDist = (Integer)DragonseekerConfig.COMMON.basic_optimalDistance.get();
            this.maxDist = (Integer)DragonseekerConfig.COMMON.basic_maxDistance.get();
            this.minPing = (Double)DragonseekerConfig.COMMON.basic_minPingChance.get();
            this.maxPing = (Double)DragonseekerConfig.COMMON.basic_maxPingChance.get();
            this.minSig = (Integer)DragonseekerConfig.COMMON.basic_pingCapRadius.get();
            this.pow = (Double)DragonseekerConfig.COMMON.basic_sigPower.get();
            this.minVol = ((Double)DragonseekerConfig.COMMON.basic_minVol.get()).floatValue();
            this.maxVol = ((Double)DragonseekerConfig.COMMON.basic_maxVol.get()).floatValue();
            this.minPitch = ((Double)DragonseekerConfig.COMMON.basic_minPitch.get()).floatValue();
            this.maxPitch = ((Double)DragonseekerConfig.COMMON.basic_maxPitch.get()).floatValue();
            this.detectsCorpses = (Boolean)DragonseekerConfig.COMMON.basic_detectsCorpses.get();
            this.detectsTame = (Boolean)DragonseekerConfig.COMMON.basic_detectsTame.get();
            this.isDefault = false;
        } else if (this.seekerType == 2) {
            this.opDist = (Integer)DragonseekerConfig.COMMON.epic_optimalDistance.get();
            this.maxDist = (Integer)DragonseekerConfig.COMMON.epic_maxDistance.get();
            this.minPing = (Double)DragonseekerConfig.COMMON.epic_minPingChance.get();
            this.maxPing = (Double)DragonseekerConfig.COMMON.epic_maxPingChance.get();
            this.minSig = (Integer)DragonseekerConfig.COMMON.epic_pingCapRadius.get();
            this.pow = (Double)DragonseekerConfig.COMMON.epic_sigPower.get();
            this.minVol = ((Double)DragonseekerConfig.COMMON.epic_minVol.get()).floatValue();
            this.maxVol = ((Double)DragonseekerConfig.COMMON.epic_maxVol.get()).floatValue();
            this.minPitch = ((Double)DragonseekerConfig.COMMON.epic_minPitch.get()).floatValue();
            this.maxPitch = ((Double)DragonseekerConfig.COMMON.epic_maxPitch.get()).floatValue();
            this.detectsCorpses = (Boolean)DragonseekerConfig.COMMON.epic_detectsCorpses.get();
            this.detectsTame = (Boolean)DragonseekerConfig.COMMON.epic_detectsTame.get();
            this.isDefault = false;
        } else if (this.seekerType == 3) {
            this.opDist = (Integer)DragonseekerConfig.COMMON.legendary_optimalDistance.get();
            this.maxDist = (Integer)DragonseekerConfig.COMMON.legendary_maxDistance.get();
            this.minPing = (Double)DragonseekerConfig.COMMON.legendary_minPingChance.get();
            this.maxPing = (Double)DragonseekerConfig.COMMON.legendary_maxPingChance.get();
            this.minSig = (Integer)DragonseekerConfig.COMMON.legendary_pingCapRadius.get();
            this.pow = (Double)DragonseekerConfig.COMMON.legendary_sigPower.get();
            this.minVol = ((Double)DragonseekerConfig.COMMON.legendary_minVol.get()).floatValue();
            this.maxVol = ((Double)DragonseekerConfig.COMMON.legendary_maxVol.get()).floatValue();
            this.minPitch = ((Double)DragonseekerConfig.COMMON.legendary_minPitch.get()).floatValue();
            this.maxPitch = ((Double)DragonseekerConfig.COMMON.legendary_maxPitch.get()).floatValue();
            this.detectsCorpses = (Boolean)DragonseekerConfig.COMMON.legendary_detectsCorpses.get();
            this.detectsTame = (Boolean)DragonseekerConfig.COMMON.legendary_detectsTame.get();
            this.isDefault = false;
        } else if (this.seekerType == 4) {
            this.opDist = (Integer)DragonseekerConfig.COMMON.mythic_optimalDistance.get();
            this.maxDist = (Integer)DragonseekerConfig.COMMON.mythic_maxDistance.get();
            this.minPing = (Double)DragonseekerConfig.COMMON.mythic_minPingChance.get();
            this.maxPing = (Double)DragonseekerConfig.COMMON.mythic_maxPingChance.get();
            this.minSig = (Integer)DragonseekerConfig.COMMON.mythic_pingCapRadius.get();
            this.pow = (Double)DragonseekerConfig.COMMON.mythic_sigPower.get();
            this.minVol = ((Double)DragonseekerConfig.COMMON.mythic_minVol.get()).floatValue();
            this.maxVol = ((Double)DragonseekerConfig.COMMON.mythic_maxVol.get()).floatValue();
            this.minPitch = ((Double)DragonseekerConfig.COMMON.mythic_minPitch.get()).floatValue();
            this.maxPitch = ((Double)DragonseekerConfig.COMMON.mythic_maxPitch.get()).floatValue();
            this.detectsCorpses = (Boolean)DragonseekerConfig.COMMON.mythic_detectsCorpses.get();
            this.detectsTame = (Boolean)DragonseekerConfig.COMMON.mythic_detectsTame.get();
            this.isDefault = false;
        }
    }
}

