/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.world.components.feature.templates.GraveyardFeature;
import twilightforest.world.components.processors.BoxCuttingProcessor;
import twilightforest.world.components.processors.CobbleVariants;
import twilightforest.world.components.processors.NagastoneVariants;
import twilightforest.world.components.processors.SmartGrassProcessor;
import twilightforest.world.components.processors.SmoothStoneVariants;
import twilightforest.world.components.processors.StateTransfiguringProcessor;
import twilightforest.world.components.processors.StoneBricksVariants;
import twilightforest.world.components.processors.TargetedRotProcessor;
import twilightforest.world.components.processors.WoodPaletteSwizzle;
import twilightforest.world.components.structures.courtyard.CourtyardTerraceTemplateProcessor;

public class TFStructureProcessors {
    public static final DeferredRegister<StructureProcessorType<?>> STRUCTURE_PROCESSORS = DeferredRegister.create((ResourceKey)Registries.f_256983_, (String)"twilightforest");
    public static final RegistryObject<StructureProcessorType<CobbleVariants>> COBBLE_VARIANTS = TFStructureProcessors.registerProcessor("cobble_variants", () -> () -> CobbleVariants.CODEC);
    public static final RegistryObject<StructureProcessorType<SmoothStoneVariants>> SMOOTH_STONE_VARIANTS = TFStructureProcessors.registerProcessor("smooth_stone_variants", () -> () -> SmoothStoneVariants.CODEC);
    public static final RegistryObject<StructureProcessorType<StoneBricksVariants>> STONE_BRICK_VARIANTS = TFStructureProcessors.registerProcessor("stone_brick_variants", () -> () -> StoneBricksVariants.CODEC);
    public static final RegistryObject<StructureProcessorType<NagastoneVariants>> NAGASTONE_VARIANTS = TFStructureProcessors.registerProcessor("nagastone_variants", () -> () -> NagastoneVariants.CODEC);
    public static final RegistryObject<StructureProcessorType<StateTransfiguringProcessor>> STATE_TRANSFIGURING = TFStructureProcessors.registerProcessor("state_transfiguring", () -> () -> StateTransfiguringProcessor.CODEC);
    public static final RegistryObject<StructureProcessorType<WoodPaletteSwizzle>> PLANK_SWIZZLE = TFStructureProcessors.registerProcessor("wood_swizzle", () -> () -> WoodPaletteSwizzle.CODEC);
    public static final RegistryObject<StructureProcessorType<SmartGrassProcessor>> SMART_GRASS = TFStructureProcessors.registerProcessor("smart_grass", () -> () -> SmartGrassProcessor.CODEC);
    public static final RegistryObject<StructureProcessorType<BoxCuttingProcessor>> BOX_CUTTING_PROCESSOR = TFStructureProcessors.registerProcessor("box_cutting", () -> () -> BoxCuttingProcessor.CODEC);
    public static final RegistryObject<StructureProcessorType<TargetedRotProcessor>> TARGETED_ROT = TFStructureProcessors.registerProcessor("targeted_rot", () -> () -> TargetedRotProcessor.CODEC);
    public static final RegistryObject<StructureProcessorType<GraveyardFeature.WebTemplateProcessor>> WEB = TFStructureProcessors.registerProcessor("web", () -> () -> GraveyardFeature.WebTemplateProcessor.CODEC);
    public static final RegistryObject<StructureProcessorType<CourtyardTerraceTemplateProcessor>> COURTYARD_TERRACE = TFStructureProcessors.registerProcessor("courtyard_terrace", () -> () -> CourtyardTerraceTemplateProcessor.CODEC);

    public static <P extends StructureProcessor> RegistryObject<StructureProcessorType<P>> registerProcessor(String name, Supplier<StructureProcessorType<P>> processor) {
        return STRUCTURE_PROCESSORS.register(name, processor);
    }
}

