/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFConfiguredFeatures;
import twilightforest.world.components.placements.AvoidLandmarkModifier;
import twilightforest.world.components.placements.ChunkBlanketingModifier;
import twilightforest.world.components.placements.ChunkCenterModifier;

public class TFPlacedFeatures {
    public static final ResourceKey<PlacedFeature> PLACED_LAKE_LAVA = TFPlacedFeatures.registerKey("lava_lake");
    public static final ResourceKey<PlacedFeature> PLACED_LAKE_WATER = TFPlacedFeatures.registerKey("water_lake");
    public static final ResourceKey<PlacedFeature> PLACED_DRUID_HUT = TFPlacedFeatures.registerKey("druid_hut");
    public static final ResourceKey<PlacedFeature> PLACED_GRAVEYARD = TFPlacedFeatures.registerKey("graveyard");
    public static final ResourceKey<PlacedFeature> PLACED_BIG_MUSHGLOOM = TFPlacedFeatures.registerKey("big_mushgloom");
    public static final ResourceKey<PlacedFeature> PLACED_FALLEN_LEAVES = TFPlacedFeatures.registerKey("fallen_leaves");
    public static final ResourceKey<PlacedFeature> PLACED_FIDDLEHEAD = TFPlacedFeatures.registerKey("fiddlehead");
    public static final ResourceKey<PlacedFeature> PLACED_FIRE_JET = TFPlacedFeatures.registerKey("fire_jet");
    public static final ResourceKey<PlacedFeature> PLACED_FOUNDATION = TFPlacedFeatures.registerKey("foundation");
    public static final ResourceKey<PlacedFeature> PLACED_GROVE_RUINS = TFPlacedFeatures.registerKey("grove_ruins");
    public static final ResourceKey<PlacedFeature> PLACED_HOLLOW_LOG = TFPlacedFeatures.registerKey("hollow_log");
    public static final ResourceKey<PlacedFeature> PLACED_HOLLOW_STUMP = TFPlacedFeatures.registerKey("hollow_stump");
    public static final ResourceKey<PlacedFeature> PLACED_HUGE_LILY_PAD = TFPlacedFeatures.registerKey("huge_lily_pad");
    public static final ResourceKey<PlacedFeature> PLACED_HUGE_WATER_LILY = TFPlacedFeatures.registerKey("huge_water_lily");
    public static final ResourceKey<PlacedFeature> PLACED_MAYAPPLE = TFPlacedFeatures.registerKey("mayapple");
    public static final ResourceKey<PlacedFeature> PLACED_MONOLITH = TFPlacedFeatures.registerKey("monolith");
    public static final ResourceKey<PlacedFeature> PLACED_MUSHGLOOM_CLUSTER = TFPlacedFeatures.registerKey("mushgloom_cluster");
    public static final ResourceKey<PlacedFeature> PLACED_MYCELIUM_BLOB = TFPlacedFeatures.registerKey("mycelium_blob");
    public static final ResourceKey<PlacedFeature> PLACED_OUTSIDE_STALAGMITE = TFPlacedFeatures.registerKey("outside_stalagmite");
    public static final ResourceKey<PlacedFeature> PLACED_PLANT_ROOTS = TFPlacedFeatures.registerKey("plant_roots");
    public static final ResourceKey<PlacedFeature> PLACED_PUMPKIN_LAMPPOST = TFPlacedFeatures.registerKey("pumpkin_lamppost");
    public static final ResourceKey<PlacedFeature> PLACED_SMOKER = TFPlacedFeatures.registerKey("smoker");
    public static final ResourceKey<PlacedFeature> PLACED_STONE_CIRCLE = TFPlacedFeatures.registerKey("stone_circle");
    public static final ResourceKey<PlacedFeature> PLACED_THORNS = TFPlacedFeatures.registerKey("thorns");
    public static final ResourceKey<PlacedFeature> PLACED_TORCH_BERRIES = TFPlacedFeatures.registerKey("torch_berries");
    public static final ResourceKey<PlacedFeature> PLACED_TROLL_ROOTS = TFPlacedFeatures.registerKey("troll_roots");
    public static final ResourceKey<PlacedFeature> PLACED_VANILLA_ROOTS = TFPlacedFeatures.registerKey("vanilla_roots");
    public static final ResourceKey<PlacedFeature> PLACED_WEBS = TFPlacedFeatures.registerKey("webs");
    public static final ResourceKey<PlacedFeature> PLACED_WOOD_ROOTS_SPREAD = TFPlacedFeatures.registerKey("wood_roots");
    public static final ResourceKey<PlacedFeature> PLACED_SNOW_UNDER_TREES = TFPlacedFeatures.registerKey("snow_under_trees");
    public static final ResourceKey<PlacedFeature> PLACED_TF_OAK_FALLEN_LOG = TFPlacedFeatures.registerKey("tf_oak_fallen_log");
    public static final ResourceKey<PlacedFeature> PLACED_CANOPY_FALLEN_LOG = TFPlacedFeatures.registerKey("canopy_fallen_log");
    public static final ResourceKey<PlacedFeature> PLACED_MANGROVE_FALLEN_LOG = TFPlacedFeatures.registerKey("mangrove_fallen_log");
    public static final ResourceKey<PlacedFeature> PLACED_SPRUCE_FALLEN_LOG = TFPlacedFeatures.registerKey("spruce_fallen_log");
    public static final ResourceKey<PlacedFeature> PLACED_SMALL_GRANITE = TFPlacedFeatures.registerKey("small_granite");
    public static final ResourceKey<PlacedFeature> PLACED_SMALL_DIORITE = TFPlacedFeatures.registerKey("small_diorite");
    public static final ResourceKey<PlacedFeature> PLACED_SMALL_ANDESITE = TFPlacedFeatures.registerKey("small_andesite");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_MUSHGLOOMS = TFPlacedFeatures.registerKey("dark_mushglooms");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_PUMPKINS = TFPlacedFeatures.registerKey("dark_pumpkins");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_GRASS = TFPlacedFeatures.registerKey("dark_grass");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_FERNS = TFPlacedFeatures.registerKey("dark_ferns");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_MUSHROOMS = TFPlacedFeatures.registerKey("dark_mushrooms");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_DEAD_BUSHES = TFPlacedFeatures.registerKey("dark_dead_bushes");
    public static final ResourceKey<PlacedFeature> PLACED_LEGACY_COAL_ORE = TFPlacedFeatures.registerKey("legacy_coal_ore");
    public static final ResourceKey<PlacedFeature> PLACED_LEGACY_IRON_ORE = TFPlacedFeatures.registerKey("legacy_iron_ore");
    public static final ResourceKey<PlacedFeature> PLACED_LEGACY_GOLD_ORE = TFPlacedFeatures.registerKey("legacy_gold_ore");
    public static final ResourceKey<PlacedFeature> PLACED_LEGACY_REDSTONE_ORE = TFPlacedFeatures.registerKey("legacy_redstone_ore");
    public static final ResourceKey<PlacedFeature> PLACED_LEGACY_DIAMOND_ORE = TFPlacedFeatures.registerKey("legacy_diamond_ore");
    public static final ResourceKey<PlacedFeature> PLACED_LEGACY_LAPIS_ORE = TFPlacedFeatures.registerKey("legacy_lapis_ore");
    public static final ResourceKey<PlacedFeature> PLACED_LEGACY_COPPER_ORE = TFPlacedFeatures.registerKey("legacy_copper_ore");
    public static final ResourceKey<PlacedFeature> PLACED_WELL_PLACER = TFPlacedFeatures.registerKey("well_placer");
    public static final ResourceKey<PlacedFeature> PLACED_LAMPPOST_PLACER = TFPlacedFeatures.registerKey("lamppost_placer");
    public static final ResourceKey<PlacedFeature> PLACED_DEFAULT_FALLEN_LOGS = TFPlacedFeatures.registerKey("default_fallen_logs");
    public static final ResourceKey<PlacedFeature> PLACED_FLOWER_PLACER = TFPlacedFeatures.registerKey("flower_placer");
    public static final ResourceKey<PlacedFeature> PLACED_FLOWER_PLACER_ALT = TFPlacedFeatures.registerKey("flower_placer_alt");
    public static final ResourceKey<PlacedFeature> PLACED_DEAD_CANOPY_TREE = TFPlacedFeatures.registerKey("tree/dead_canopy_tree");
    public static final ResourceKey<PlacedFeature> PLACED_MANGROVE_TREE = TFPlacedFeatures.registerKey("tree/mangrove_tree");
    public static final ResourceKey<PlacedFeature> PLACED_TWILIGHT_OAK_TREE = TFPlacedFeatures.registerKey("tree/twilight_oak_tree");
    public static final ResourceKey<PlacedFeature> PLACED_LARGE_TWILIGHT_OAK_TREE = TFPlacedFeatures.registerKey("tree/large_twilight_oak_tree");
    public static final ResourceKey<PlacedFeature> PLACED_FOREST_CANOPY_OAK_TREE = TFPlacedFeatures.registerKey("tree/forest_canopy_oak_tree");
    public static final ResourceKey<PlacedFeature> PLACED_SAVANNAH_OAK_TREE = TFPlacedFeatures.registerKey("tree/savannah_oak_tree");
    public static final ResourceKey<PlacedFeature> PLACED_SAVANNAH_CANOPY_OAK_TREE = TFPlacedFeatures.registerKey("tree/savannah_canopy_oak_tree");
    public static final ResourceKey<PlacedFeature> PLACED_SWAMPY_OAK_TREE = TFPlacedFeatures.registerKey("tree/swampy_oak_tree");
    public static final ResourceKey<PlacedFeature> PLACED_DARKWOOD_TREE = TFPlacedFeatures.registerKey("tree/darkwood_tree");
    public static final ResourceKey<PlacedFeature> PLACED_HOLLOW_OAK_TREE = TFPlacedFeatures.registerKey("tree/hollow_oak");
    public static final ResourceKey<PlacedFeature> PLACED_CANOPY_TREES = TFPlacedFeatures.registerKey("tree/selector/canopy_trees");
    public static final ResourceKey<PlacedFeature> PLACED_DENSE_CANOPY_TREES = TFPlacedFeatures.registerKey("tree/selector/dense_canopy_trees");
    public static final ResourceKey<PlacedFeature> PLACED_FIREFLY_FOREST_TREES = TFPlacedFeatures.registerKey("tree/selector/firefly_forest_trees");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_FOREST_TREES = TFPlacedFeatures.registerKey("tree/selector/dark_forest_trees");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_FOREST_TREE_MIX = TFPlacedFeatures.registerKey("tree/selector/dark_forest_tree_mix");
    public static final ResourceKey<PlacedFeature> PLACED_HIGHLANDS_TREES = TFPlacedFeatures.registerKey("tree/selector/highlands_trees");
    public static final ResourceKey<PlacedFeature> PLACED_ENCHANTED_FOREST_TREES = TFPlacedFeatures.registerKey("tree/selector/enchanted_forest_trees");
    public static final ResourceKey<PlacedFeature> PLACED_SNOWY_FOREST_TREES = TFPlacedFeatures.registerKey("tree/selector/snowy_forest_trees");
    public static final ResourceKey<PlacedFeature> PLACED_VANILLA_TF_TREES = TFPlacedFeatures.registerKey("tree/selector/vanilla_trees");
    public static final ResourceKey<PlacedFeature> PLACED_VANILLA_TF_BIG_MUSH = TFPlacedFeatures.registerKey("tree/selector/vanilla_mushrooms");
    public static final ResourceKey<PlacedFeature> PLACED_CANOPY_MUSHROOMS_SPARSE = TFPlacedFeatures.registerKey("mushroom/canopy_mushrooms_sparse");
    public static final ResourceKey<PlacedFeature> PLACED_CANOPY_MUSHROOMS_DENSE = TFPlacedFeatures.registerKey("mushroom/canopy_mushrooms_dense");

    private static List<PlacementModifier> tfTreeCheckArea(BlockState sapling) {
        return List.of(InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), PlacementUtils.f_195355_, AvoidLandmarkModifier.checkSurface(), PlacementUtils.m_206493_((Block)sapling.m_60734_()), BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> tfTreeCheckArea(PlacementModifier count, BlockState sapling) {
        return ImmutableList.of((Object)count, (Object)InSquarePlacement.m_191715_(), (Object)SurfaceWaterDepthFilter.m_191950_((int)0), (Object)PlacementUtils.f_195355_, (Object)((Object)AvoidLandmarkModifier.checkSurface()), (Object)PlacementUtils.m_206493_((Block)sapling.m_60734_()), (Object)BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> darkForestTreeCheck(PlacementModifier count) {
        return ImmutableList.of((Object)count, (Object)InSquarePlacement.m_191715_(), (Object)SurfaceWaterDepthFilter.m_191950_((int)0), (Object)PlacementUtils.f_195355_, (Object)((Object)new AvoidLandmarkModifier(true, false, 10)), (Object)BiomeFilter.m_191561_());
    }

    private static ImmutableList.Builder<PlacementModifier> tfFeatureCheckArea(AvoidLandmarkModifier filter, int rarity) {
        return ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.m_191900_((int)rarity), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, filter, BiomeFilter.m_191561_()});
    }

    private static ImmutableList.Builder<PlacementModifier> tfFeatureCheckArea(AvoidLandmarkModifier filter, int rarity, PlacementModifier ... extra) {
        return ImmutableList.builder().add((Object[])extra).add((Object[])new PlacementModifier[]{filter, RarityFilter.m_191900_((int)rarity), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
    }

    private static ImmutableList.Builder<PlacementModifier> hollowLog(AvoidLandmarkModifier filter) {
        return ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.m_191900_((int)40), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, filter});
    }

    public static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)TwilightForestMod.prefix(name));
    }

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter features = context.m_255420_(Registries.f_256911_);
        context.m_255272_(PLACED_LAKE_LAVA, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.LAKE_LAVA), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 10).build()));
        context.m_255272_(PLACED_LAKE_WATER, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.LAKE_WATER), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 4).build()));
        context.m_255272_(PLACED_DRUID_HUT, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.DRUID_HUT), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 105).build()));
        context.m_255272_(PLACED_GRAVEYARD, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.GRAVEYARD), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 70).build()));
        context.m_255272_(PLACED_BIG_MUSHGLOOM, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.BIG_MUSHGLOOM), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 1).build()));
        context.m_255272_(PLACED_FALLEN_LEAVES, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.FALLEN_LEAVES), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 1).build()));
        context.m_255272_(PLACED_FIDDLEHEAD, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.FIDDLEHEAD), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_FIRE_JET, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.FIRE_JET), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_FOUNDATION, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.FOUNDATION), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 90).build()));
        context.m_255272_(PLACED_GROVE_RUINS, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.GROVE_RUINS), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 110).build()));
        context.m_255272_(PLACED_HOLLOW_LOG, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.HOLLOW_LOG), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 85).build()));
        context.m_255272_(PLACED_HOLLOW_STUMP, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.HOLLOW_STUMP), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 80).build()));
        context.m_255272_(PLACED_HUGE_LILY_PAD, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.HUGE_LILY_PAD), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, RarityFilter.m_191900_((int)20), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)10), BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_HUGE_WATER_LILY, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.HUGE_WATER_LILY), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, RarityFilter.m_191900_((int)25), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)5), BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_MAYAPPLE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.MAYAPPLE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_MONOLITH, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.MONOLITH), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 90).build()));
        context.m_255272_(PLACED_MUSHGLOOM_CLUSTER, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.MUSHGLOOM_CLUSTER), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, RarityFilter.m_191900_((int)5), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_MYCELIUM_BLOB, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.MYCELIUM_BLOB), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 3).build()));
        context.m_255272_(PLACED_OUTSIDE_STALAGMITE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.OUTSIDE_STALAGMITE), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 77).build()));
        context.m_255272_(PLACED_PLANT_ROOTS, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.PLANT_ROOTS), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkUnderground(), 1, new PlacementModifier[]{CountPlacement.m_191628_((int)4), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)10))}).build()));
        context.m_255272_(PLACED_PUMPKIN_LAMPPOST, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.PUMPKIN_LAMPPOST), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 10).build()));
        context.m_255272_(PLACED_SMOKER, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.SMOKER), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_STONE_CIRCLE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.STONE_CIRCLE), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 105).build()));
        context.m_255272_(PLACED_THORNS, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.THORNS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{ChunkBlanketingModifier.addThorns(), BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_TORCH_BERRIES, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.TORCH_BERRIES), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)60)), CountPlacement.m_191628_((int)8), AvoidLandmarkModifier.checkUnderground(), BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_TROLL_ROOTS, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.TROLL_ROOTS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)60)), CountPlacement.m_191628_((int)8), BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_VANILLA_ROOTS, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.VANILLA_ROOTS), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkUnderground(), 1, new PlacementModifier[]{CountPlacement.m_191628_((int)16), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)0)), PlacementUtils.m_206493_((Block)((Block)TFBlocks.TORCHBERRY_PLANT.get()))}).build()));
        context.m_255272_(PLACED_WEBS, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.WEBS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, CountPlacement.m_191628_((int)60), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_WOOD_ROOTS_SPREAD, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.WOOD_ROOTS_SPREAD), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkUnderground(), 40, new PlacementModifier[]{HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)0))}).build()));
        context.m_255272_(PLACED_SNOW_UNDER_TREES, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.SNOW_UNDER_TREES), (List)ImmutableList.builder().add((Object)BiomeFilter.m_191561_()).build()));
        context.m_255272_(PLACED_TF_OAK_FALLEN_LOG, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.TF_OAK_FALLEN_LOG), (List)TFPlacedFeatures.hollowLog(AvoidLandmarkModifier.checkSurface()).build()));
        context.m_255272_(PLACED_CANOPY_FALLEN_LOG, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.CANOPY_FALLEN_LOG), (List)TFPlacedFeatures.hollowLog(AvoidLandmarkModifier.checkSurface()).build()));
        context.m_255272_(PLACED_MANGROVE_FALLEN_LOG, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.MANGROVE_FALLEN_LOG), (List)TFPlacedFeatures.hollowLog(AvoidLandmarkModifier.checkSurface()).build()));
        context.m_255272_(PLACED_SPRUCE_FALLEN_LOG, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.SPRUCE_FALLEN_LOG), (List)TFPlacedFeatures.hollowLog(AvoidLandmarkModifier.checkSurface()).build()));
        context.m_255272_(PLACED_SMALL_GRANITE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.SMALL_GRANITE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64)), RarityFilter.m_191900_((int)10), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)5)}).build()));
        context.m_255272_(PLACED_SMALL_DIORITE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.SMALL_DIORITE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64)), RarityFilter.m_191900_((int)10), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)5)}).build()));
        context.m_255272_(PLACED_SMALL_ANDESITE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.SMALL_ANDESITE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64)), RarityFilter.m_191900_((int)10), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)5)}).build()));
        context.m_255272_(PLACED_DARK_MUSHGLOOMS, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.DARK_MUSHGLOOMS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.m_191900_((int)30), PlacementUtils.f_195354_, BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_DARK_PUMPKINS, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.DARK_PUMPKINS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.m_191900_((int)30), PlacementUtils.f_195354_, BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_DARK_GRASS, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.DARK_GRASS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.m_191900_((int)4), PlacementUtils.f_195354_, BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_DARK_FERNS, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.DARK_FERNS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.m_191900_((int)4), PlacementUtils.f_195354_, BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_DARK_MUSHROOMS, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.DARK_MUSHROOMS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_DARK_DEAD_BUSHES, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.DARK_DEAD_BUSHES), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.m_191900_((int)15), PlacementUtils.f_195354_, BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_LEGACY_COAL_ORE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.LEGACY_COAL_ORE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)127)), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)20)}).build()));
        context.m_255272_(PLACED_LEGACY_IRON_ORE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.LEGACY_IRON_ORE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)63)), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)20)}).build()));
        context.m_255272_(PLACED_LEGACY_GOLD_ORE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.LEGACY_GOLD_ORE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)31)), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)2)}).build()));
        context.m_255272_(PLACED_LEGACY_REDSTONE_ORE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.LEGACY_REDSTONE_ORE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)15)), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)8)}).build()));
        context.m_255272_(PLACED_LEGACY_DIAMOND_ORE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.LEGACY_DIAMOND_ORE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)15)), InSquarePlacement.m_191715_()}).build()));
        context.m_255272_(PLACED_LEGACY_LAPIS_ORE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.LEGACY_LAPIS_ORE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)30)), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)2)}).build()));
        context.m_255272_(PLACED_LEGACY_COPPER_ORE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.LEGACY_COPPER_ORE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)96)), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)6)}).build()));
        context.m_255272_(PLACED_WELL_PLACER, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.WELL_PLACER), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 80).build()));
        context.m_255272_(PLACED_LAMPPOST_PLACER, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.LAMPPOST_PLACER), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 2).build()));
        context.m_255272_(PLACED_DEFAULT_FALLEN_LOGS, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.DEFAULT_FALLEN_LOGS), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 40).build()));
        context.m_255272_(PLACED_FLOWER_PLACER, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.FLOWER_PLACER), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), RarityFilter.m_191900_((int)2), BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_FLOWER_PLACER_ALT, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.FLOWER_PLACER_ALT), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), RarityFilter.m_191900_((int)2), BiomeFilter.m_191561_()}).build()));
        context.m_255272_(PLACED_DEAD_CANOPY_TREE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.DEAD_CANOPY_TREE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)2, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).m_49966_())));
        context.m_255272_(PLACED_MANGROVE_TREE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.MANGROVE_TREE), List.of(PlacementUtils.m_195364_((int)3, (float)0.1f, (int)1), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)6), PlacementUtils.f_195355_, AvoidLandmarkModifier.checkSurface(), PlacementUtils.m_206493_((Block)((Block)TFBlocks.MANGROVE_SAPLING.get())), BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_TWILIGHT_OAK_TREE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.TWILIGHT_OAK_TREE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)1, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).m_49966_())));
        context.m_255272_(PLACED_LARGE_TWILIGHT_OAK_TREE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.LARGE_TWILIGHT_OAK_TREE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)1, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).m_49966_())));
        context.m_255272_(PLACED_FOREST_CANOPY_OAK_TREE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.FOREST_CANOPY_OAK_TREE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)7, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).m_49966_())));
        context.m_255272_(PLACED_SAVANNAH_CANOPY_OAK_TREE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.SAVANNAH_CANOPY_OAK_TREE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)0, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).m_49966_())));
        context.m_255272_(PLACED_SAVANNAH_OAK_TREE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.TWILIGHT_OAK_TREE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)1, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).m_49966_())));
        context.m_255272_(PLACED_SWAMPY_OAK_TREE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.SWAMPY_OAK_TREE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)4, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).m_49966_())));
        context.m_255272_(PLACED_DARKWOOD_TREE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.DARKWOOD_TREE), List.of(PlacementUtils.m_195364_((int)5, (float)0.1f, (int)1), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), PlacementUtils.f_195355_, new AvoidLandmarkModifier(true, false, 16), PlacementUtils.m_206493_((Block)((Block)TFBlocks.DARKWOOD_SAPLING.get())), BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_HOLLOW_OAK_TREE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.HOLLOW_TREE), List.of(SurfaceWaterDepthFilter.m_191950_((int)0), RarityFilter.m_191900_((int)35), PlacementUtils.f_195355_, ChunkCenterModifier.center(), new AvoidLandmarkModifier(true, false, 32), PlacementUtils.m_206493_((Block)((Block)TFBlocks.HOLLOW_OAK_SAPLING.get())), BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_CANOPY_TREES, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.CANOPY_TREES), TFPlacedFeatures.tfTreeCheckArea(((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).m_49966_())));
        context.m_255272_(PLACED_DENSE_CANOPY_TREES, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.DENSE_CANOPY_TREES), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)5, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).m_49966_())));
        context.m_255272_(PLACED_FIREFLY_FOREST_TREES, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.FIREFLY_FOREST_TREES), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)3, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).m_49966_())));
        context.m_255272_(PLACED_DARK_FOREST_TREES, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.DARKWOOD_TREE), TFPlacedFeatures.darkForestTreeCheck(PlacementUtils.m_195364_((int)8, (float)0.1f, (int)1))));
        context.m_255272_(PLACED_DARK_FOREST_TREE_MIX, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.DARK_FOREST_TREES), TFPlacedFeatures.darkForestTreeCheck(PlacementUtils.m_195364_((int)3, (float)0.1f, (int)1))));
        context.m_255272_(PLACED_HIGHLANDS_TREES, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.HIGHLANDS_TREES), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)3, (float)0.1f, (int)1), Blocks.f_50747_.m_49966_())));
        context.m_255272_(PLACED_ENCHANTED_FOREST_TREES, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.ENCHANTED_FOREST_TREES), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)5, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.RAINBOW_OAK_SAPLING.get()).m_49966_())));
        context.m_255272_(PLACED_SNOWY_FOREST_TREES, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.SNOWY_FOREST_TREES), List.of(PlacementUtils.m_195364_((int)10, (float)0.1f, (int)1), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), PlacementUtils.f_195355_, AvoidLandmarkModifier.checkSurface(), EnvironmentScanPlacement.m_191653_((Direction)Direction.UP, (BlockPredicate)BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224780_((Block[])new Block[]{Blocks.f_152499_})), (int)8), BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_50127_, Blocks.f_152499_})), BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_VANILLA_TF_TREES, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.VANILLA_TF_TREES), TFPlacedFeatures.tfTreeCheckArea(((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).m_49966_())));
        context.m_255272_(PLACED_VANILLA_TF_BIG_MUSH, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.VANILLA_TF_BIG_MUSH), TFPlacedFeatures.tfTreeCheckArea(((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).m_49966_())));
        context.m_255272_(PLACED_CANOPY_MUSHROOMS_SPARSE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.CANOPY_MUSHROOMS_SPARSE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)3, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).m_49966_())));
        context.m_255272_(PLACED_CANOPY_MUSHROOMS_DENSE, (Object)new PlacedFeature((Holder)features.m_255043_(TFConfiguredFeatures.CANOPY_MUSHROOMS_DENSE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)5, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).m_49966_())));
    }
}

