/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.LightableBlock;

public class CandelabraBlock
extends Block
implements LightableBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty ON_WALL = BooleanProperty.m_61465_((String)"on_wall");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape CANDLES_NORTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)7.0, (double)2.0, (double)15.0, (double)15.0, (double)6.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)1.0, (double)3.5, (double)15.0, (double)7.0, (double)4.5), Block.m_49796_((double)7.5, (double)1.0, (double)1.0, (double)8.5, (double)7.0, (double)7.0), Block.m_49796_((double)6.0, (double)2.0, (double)0.0, (double)10.0, (double)6.0, (double)1.0)});
    public static final VoxelShape CANDLES_SOUTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)7.0, (double)10.0, (double)15.0, (double)15.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)1.0, (double)11.5, (double)15.0, (double)7.0, (double)12.5), Block.m_49796_((double)7.5, (double)1.0, (double)9.0, (double)8.5, (double)7.0, (double)15.0), Block.m_49796_((double)6.0, (double)2.0, (double)15.0, (double)10.0, (double)6.0, (double)16.0)});
    public static final VoxelShape CANDLES_WEST = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)7.0, (double)1.0, (double)6.0, (double)15.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)3.5, (double)1.0, (double)1.0, (double)4.5, (double)7.0, (double)15.0), Block.m_49796_((double)1.0, (double)1.0, (double)7.5, (double)7.0, (double)7.0, (double)8.5), Block.m_49796_((double)0.0, (double)2.0, (double)6.0, (double)1.0, (double)6.0, (double)10.0)});
    public static final VoxelShape CANDLES_EAST = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)10.0, (double)7.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)11.5, (double)1.0, (double)1.0, (double)12.5, (double)7.0, (double)15.0), Block.m_49796_((double)9.0, (double)1.0, (double)7.5, (double)15.0, (double)7.0, (double)8.5), Block.m_49796_((double)15.0, (double)2.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0)});
    public static final VoxelShape CANDLES_X = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)7.0, (double)1.0, (double)10.0, (double)15.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)7.5, (double)1.0, (double)1.0, (double)8.5, (double)7.0, (double)15.0), Block.m_49796_((double)5.0, (double)1.0, (double)7.5, (double)11.0, (double)7.0, (double)8.5), Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0)});
    public static final VoxelShape CANDLES_Z = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)7.0, (double)6.0, (double)15.0, (double)15.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)1.0, (double)7.5, (double)15.0, (double)7.0, (double)8.5), Block.m_49796_((double)7.5, (double)1.0, (double)5.0, (double)8.5, (double)7.0, (double)11.0), Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0)});
    public static final List<Vec3> NORTH_OFFSETS = List.of(new Vec3(0.1875, 0.875, 0.25), new Vec3(0.5, 0.875, 0.25), new Vec3(0.8125, 0.875, 0.25));
    public static final List<Vec3> SOUTH_OFFSETS = List.of(new Vec3(0.1875, 0.875, 0.75), new Vec3(0.5, 0.875, 0.75), new Vec3(0.8125, 0.875, 0.75));
    public static final List<Vec3> WEST_OFFSETS = List.of(new Vec3(0.25, 0.875, 0.1875), new Vec3(0.25, 0.875, 0.5), new Vec3(0.25, 0.875, 0.8125));
    public static final List<Vec3> EAST_OFFSETS = List.of(new Vec3(0.75, 0.875, 0.1875), new Vec3(0.75, 0.875, 0.5), new Vec3(0.75, 0.875, 0.8125));
    public static final List<Vec3> X_OFFSETS = List.of(new Vec3(0.5, 0.875, 0.1875), new Vec3(0.5, 0.875, 0.5), new Vec3(0.5, 0.875, 0.8125));
    public static final List<Vec3> Z_OFFSETS = List.of(new Vec3(0.1875, 0.875, 0.5), new Vec3(0.5, 0.875, 0.5), new Vec3(0.8125, 0.875, 0.5));

    public CandelabraBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NONE))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ON_WALL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Iterable<Vec3> getParticleOffsets(BlockState state, LevelAccessor accessor, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)ON_WALL)).booleanValue()) {
            return switch ((Direction)state.m_61143_((Property)FACING)) {
                case Direction.SOUTH -> SOUTH_OFFSETS;
                case Direction.WEST -> WEST_OFFSETS;
                case Direction.EAST -> EAST_OFFSETS;
                default -> NORTH_OFFSETS;
            };
        }
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? X_OFFSETS : Z_OFFSETS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)ON_WALL)).booleanValue()) {
            return switch ((Direction)state.m_61143_((Property)FACING)) {
                case Direction.SOUTH -> CANDLES_SOUTH;
                case Direction.WEST -> CANDLES_WEST;
                case Direction.EAST -> CANDLES_EAST;
                default -> CANDLES_NORTH;
            };
        }
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? CANDLES_X : CANDLES_Z;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return this.lightCandles(state, level, pos, player, hand, result);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult result, Projectile projectile) {
        this.lightCandlesWithProjectile(level, state, result, projectile);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction clickDirection = context.m_43719_();
        boolean onBottomBlock = clickDirection == Direction.UP;
        Direction[] placements = context.m_6232_();
        BlockPos placePos = context.m_8083_();
        Level level = context.m_43725_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_192917_((Fluid)Fluids.f_76193_);
        if (onBottomBlock) {
            if (CandelabraBlock.canSurvive((LevelReader)level, placePos, false, context.m_8125_())) {
                return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)ON_WALL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            }
            for (Direction nextSide : placements) {
                if (!nextSide.m_122434_().m_122479_() || !CandelabraBlock.canSurvive((LevelReader)level, placePos, true, nextSide)) continue;
                return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)ON_WALL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            }
        } else {
            for (Direction nextSide : placements) {
                if (!nextSide.m_122434_().m_122479_() || !CandelabraBlock.canSurvive((LevelReader)level, placePos, true, nextSide)) continue;
                return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)ON_WALL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            }
            if (CandelabraBlock.canSurvive((LevelReader)level, placePos, false, context.m_8125_())) {
                return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)ON_WALL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            }
        }
        return null;
    }

    @Override
    public boolean canBeLit(BlockState state) {
        return state.m_61143_((Property)LIGHTING) == LightableBlock.Lighting.NONE && (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public boolean m_7361_(LevelAccessor accessor, BlockPos pos, BlockState state, FluidState fluid) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && fluid.m_192917_((Fluid)Fluids.f_76193_)) {
            boolean flag;
            boolean bl = flag = state.m_61143_((Property)LIGHTING) != LightableBlock.Lighting.NONE;
            if (flag) {
                this.extinguish(null, state, accessor, pos);
            }
            accessor.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NONE)), 3);
            accessor.m_186469_(pos, fluid.m_76152_(), fluid.m_76152_().m_6718_((LevelReader)accessor));
            return true;
        }
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ON_WALL, LIGHTING, WATERLOGGED});
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        return CandelabraBlock.canSurvive(reader, pos, (Boolean)state.m_61143_((Property)ON_WALL), (Direction)state.m_61143_((Property)FACING));
    }

    public static boolean canSurvive(LevelReader reader, BlockPos pos, boolean onWall, Direction facing) {
        return CandelabraBlock.m_49863_((LevelReader)reader, (BlockPos)(onWall ? pos.m_121945_(facing) : pos.m_7495_()), (Direction)Direction.UP);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        boolean ominous;
        boolean bl = ominous = state.m_61143_((Property)LIGHTING) == LightableBlock.Lighting.OMINOUS;
        if (state.m_61143_((Property)LIGHTING) != LightableBlock.Lighting.NONE) {
            this.getParticleOffsets(state, (LevelAccessor)level, pos).forEach(vec3 -> this.addParticlesAndSound(level, pos, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, rand, ominous));
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            accessor.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
        return super.m_7417_(state, facing, facingState, accessor, currentPos, facingPos);
    }
}

