/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.seafarer.common.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.peeko32213.seafarer.common.entity.StatedAnimal;
import com.peeko32213.seafarer.common.entity.goal.GrazeAlgaeGoal;
import com.peeko32213.seafarer.common.entity.misc.state.EntityAction;
import com.peeko32213.seafarer.common.entity.misc.state.RandomStateGoal;
import com.peeko32213.seafarer.common.entity.misc.state.StateHelper;
import com.peeko32213.seafarer.common.entity.misc.state.WeightedState;
import com.peeko32213.seafarer.core.registry.SFBlocks;
import com.peeko32213.seafarer.core.registry.SFItems;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntityCrab
extends StatedAnimal
implements GeoAnimatable,
Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(EntityCrab.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation CRAB_IDLE = RawAnimation.begin().thenLoop("animation.crab.idle");
    private static final RawAnimation CRAB_WALK = RawAnimation.begin().thenLoop("animation.crab.walk");
    private static final RawAnimation CRAB_SPRINT_1 = RawAnimation.begin().thenLoop("animation.crab.sprint1");
    private static final RawAnimation CRAB_SPRINT_2 = RawAnimation.begin().thenLoop("animation.crab.sprint2");
    private static final RawAnimation CRAB_SWIM = RawAnimation.begin().thenLoop("animation.crab.swim");
    private static final RawAnimation CRAB_GRAZE = RawAnimation.begin().thenLoop("animation.crab.graze");
    private static final RawAnimation CRAB_DANCE = RawAnimation.begin().thenLoop("animation.crab.dance");
    private static final RawAnimation CRAB_BLINK = RawAnimation.begin().thenLoop("animation.crab.blink");
    private static final RawAnimation CRAB_CLAW = RawAnimation.begin().thenLoop("animation.crab.claw");
    private static final RawAnimation CRAB_WAVE = RawAnimation.begin().thenLoop("animation.crab.wave");
    private static final EntityDataAccessor<Boolean> GRAZE = SynchedEntityData.m_135353_(EntityCrab.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WAVING = SynchedEntityData.m_135353_(EntityCrab.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CRAB_CLAWING = SynchedEntityData.m_135353_(EntityCrab.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CRAB_BLINKING = SynchedEntityData.m_135353_(EntityCrab.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityAction CRAB_WAVE_ACTION = new EntityAction(0, e -> {}, 1);
    private static final StateHelper CRAB_WAVE_STATE = StateHelper.Builder.state(WAVING, "crab_waving").playTime(60).stopTime(100).affectsAI(true).affectedFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK)).entityAction(CRAB_WAVE_ACTION).build();
    private static final EntityAction CRAB_CLAW_ACTION = new EntityAction(0, e -> {}, 1);
    private static final StateHelper CRAB_CLAW_STATE = StateHelper.Builder.state(CRAB_CLAWING, "crab_clawing").playTime(60).stopTime(100).affectsAI(true).entityAction(CRAB_CLAW_ACTION).build();
    private static final EntityAction CRAB_BLINK_ACTION = new EntityAction(0, e -> {}, 1);
    private static final StateHelper CRAB_BLINK_STATE = StateHelper.Builder.state(CRAB_BLINKING, "crab_blinking").playTime(60).stopTime(100).affectsAI(true).affectedFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK)).entityAction(CRAB_BLINK_ACTION).build();
    private GrazeAlgaeGoal eatBlockGoal;
    private int eatAnimationTick;

    public EntityCrab(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22284_, 3.0).m_22268_(Attributes.f_22285_, 2.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    protected void m_8099_() {
        this.eatBlockGoal = new GrazeAlgaeGoal((Mob)this);
        this.f_21345_.m_25352_(2, (Goal)this.eatBlockGoal);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 5.0f, 2.5, 2.7, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, new RandomStateGoal<EntityCrab>(this));
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    public boolean m_6040_() {
        return true;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
    }

    public InteractionResult m_6071_(Player p_27477_, InteractionHand p_27478_) {
        return Bucketable.m_148828_((Player)p_27477_, (InteractionHand)p_27478_, (LivingEntity)this).orElse(super.m_6071_(p_27477_, p_27478_));
    }

    public void m_7822_(byte pId) {
        if (pId == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.m_7822_(pId);
        }
    }

    public boolean isEating() {
        return this.eatAnimationTick > 0;
    }

    private boolean isStillEnough() {
        return this.m_20184_().m_165924_() < 0.05;
    }

    public static boolean canDig(LivingEntity entity) {
        BlockPos pos = entity.m_20097_();
        return entity.m_9236_().m_8055_(pos).m_60713_((Block)SFBlocks.ALGAE_BLOCK.get());
    }

    protected <E extends EntityCrab> PlayState Controller(AnimationState<E> event) {
        if (!(event.getLimbSwingAmount() > -0.06f && event.getLimbSwingAmount() < 0.06f || this.m_20069_())) {
            if (this.m_20142_()) {
                event.setAndContinue(CRAB_SPRINT_1);
                event.getController().setAnimationSpeed(2.0);
                return PlayState.CONTINUE;
            }
            event.setAndContinue(CRAB_WALK);
            return PlayState.CONTINUE;
        }
        if (this.m_20069_()) {
            event.setAndContinue(CRAB_SWIM);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.getBooleanState(CRAB_BLINKING)) {
            return event.setAndContinue(CRAB_BLINK);
        }
        if (this.getBooleanState(CRAB_CLAWING)) {
            return event.setAndContinue(CRAB_CLAW);
        }
        if (this.getBooleanState(WAVING)) {
            return event.setAndContinue(CRAB_WAVE);
        }
        return event.setAndContinue(CRAB_IDLE);
    }

    protected <E extends EntityCrab> PlayState eatController(AnimationState<E> event) {
        if (this.isEating()) {
            event.setAndContinue(CRAB_GRAZE);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Graze", 5, this::eatController)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return this.f_19797_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(CRAB_BLINKING, (Object)false);
        this.f_19804_.m_135372_(CRAB_CLAWING, (Object)false);
        this.f_19804_.m_135372_(WAVING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean p_203706_1_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_203706_1_);
    }

    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        compoundnbt.m_128350_("Health", this.m_21223_());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
    }

    public ItemStack m_28282_() {
        ItemStack stack = new ItemStack((ItemLike)SFItems.SHORE_CRAB_BUCKET.get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11779_;
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @javax.annotation.Nullable SpawnGroupData spawnGroupData, @javax.annotation.Nullable CompoundTag tag) {
        spawnGroupData = super.m_6518_(levelAccessor, difficultyInstance, spawnType, spawnGroupData, tag);
        return spawnGroupData;
    }

    public static boolean checkCrabSpawnRules(EntityType<? extends EntityCrab> dino, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource p_186242_) {
        return EntityCrab.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    @Override
    public ImmutableMap<String, StateHelper> getStates() {
        return ImmutableMap.of((Object)CRAB_BLINK_STATE.getName(), (Object)CRAB_BLINK_STATE, (Object)CRAB_CLAW_STATE.getName(), (Object)CRAB_CLAW_STATE, (Object)CRAB_WAVE_STATE.getName(), (Object)CRAB_WAVE_STATE);
    }

    @Override
    public List<WeightedState<StateHelper>> getWeightedStatesToPerform() {
        return ImmutableList.of(WeightedState.of(CRAB_BLINK_STATE, 77), WeightedState.of(CRAB_CLAW_STATE, 15), WeightedState.of(CRAB_WAVE_STATE, 10));
    }
}

