/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common.items;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import teamdraco.finsandstails.client.model.armor.HorateeJetpackModel;
import teamdraco.finsandstails.client.render.ArmorItemRenderer;
import teamdraco.finsandstails.common.items.FinsArmorMaterial;
import teamdraco.finsandstails.registry.FTItems;
import teamdraco.finsandstails.registry.FTSounds;

public class ArmoredGopjetJetpackItem
extends ArmorItem
implements GeoItem {
    public static final ArmorMaterial MATERIAL = new FinsArmorMaterial("finsandtails:horatee_jet_jetpack", 0, new int[]{2, 5, 6, 2}, 1, SoundEvents.f_11678_, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)FTItems.ARMORED_GOPJET_JETPACK.get()}));
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Random random = new Random();
    private int bubbleSoundTime;

    public ArmoredGopjetJetpackItem() {
        super(MATERIAL, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41487_(1).m_41503_(240));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private ArmorItemRenderer<ArmoredGopjetJetpackItem> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new ArmorItemRenderer<ArmoredGopjetJetpackItem>(new HorateeJetpackModel());
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public BlockPos getBlockUnderPlayer(Player player) {
        BlockState state;
        BlockPos.MutableBlockPos position = player.m_20183_().m_122032_();
        while (!(state = player.m_9236_().m_8055_((BlockPos)position)).m_280555_() && state.m_60819_().m_76178_() || state.m_60734_() instanceof LeavesBlock) {
            position.m_122173_(Direction.DOWN);
            if (position.m_123342_() > 0) continue;
            return null;
        }
        return position;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (stack.m_41776_() - stack.m_41773_() > 1 || player.m_7500_()) {
            CompoundTag persistentData;
            Item item;
            boolean canFly = world.m_46758_(player.m_20183_());
            int flyingTicksRemaining = 0;
            int stackIndex = -1;
            BlockPos pos = this.getBlockUnderPlayer(player);
            if (!canFly && pos != null) {
                if (player.m_20183_().m_123342_() > 0 && world.m_8055_(pos).m_60713_(Blocks.f_49990_)) {
                    canFly = true;
                } else {
                    for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                        int ticksJumping;
                        ItemStack inventoryStack = player.m_150109_().m_8020_(i);
                        item = inventoryStack.m_41720_();
                        int n = ticksJumping = inventoryStack.m_41782_() ? inventoryStack.m_41783_().m_128451_("FinsFlyingTicks") : 0;
                        if (item == Items.f_42447_) {
                            flyingTicksRemaining = 100 - ticksJumping;
                        } else {
                            if (item != Items.f_42589_ || PotionUtils.m_43579_((ItemStack)inventoryStack) != Potions.f_43599_) continue;
                            flyingTicksRemaining = 30 - ticksJumping;
                        }
                        stackIndex = i;
                        canFly = true;
                        break;
                    }
                }
            }
            if ((persistentData = player.getPersistentData()).m_128471_("FinsFlying") && pos != null) {
                if (canFly || player.m_20183_().m_123342_() > 0 && world.m_8055_(pos).m_60713_(Blocks.f_49990_)) {
                    player.f_19789_ = 0.0f;
                    int ticksJumping = persistentData.m_128451_("FinsFlyingTicks") + 1;
                    if (ticksJumping % 10 == 0) {
                        stack.m_41622_(1, (LivingEntity)player, Player2 -> Player2.m_21166_(EquipmentSlot.CHEST));
                    }
                    persistentData.m_128405_("FinsFlyingTicks", ticksJumping);
                    player.m_20256_(player.m_20184_().m_82520_(0.0, 0.1, 0.0));
                }
                if (canFly || player.m_20183_().m_123342_() > 0 && world.m_8055_(pos).m_60713_(Blocks.f_49990_)) {
                    if (this.random.nextInt(100) < this.bubbleSoundTime++) {
                        this.bubbleSoundTime = 0;
                        world.m_5594_(player, player.m_20183_(), (SoundEvent)FTSounds.JETPACK_USE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    if (world.f_46443_) {
                        for (int i = 0; i < 4; ++i) {
                            float sign = Math.signum(i - 2);
                            if (sign == 0.0f) {
                                sign = 1.0f;
                            }
                            double playerRotation = Math.toRadians(player.f_20883_ + 35.0f * sign);
                            double xOffset = this.random.nextGaussian() * 0.05;
                            double yOffset = this.random.nextGaussian() * 0.01;
                            double zOffset = this.random.nextGaussian() * 0.05;
                            double xPos = player.m_20185_() + xOffset - Math.sin(-playerRotation) * 0.35;
                            double yPos = player.m_20186_() + yOffset + 0.7;
                            double zPos = player.m_20189_() + zOffset - Math.cos(playerRotation) * 0.35;
                            for (int j = 0; j <= 8; ++j) {
                                world.m_7106_((ParticleOptions)(this.random.nextInt(2) == 0 ? ParticleTypes.f_123769_ : ParticleTypes.f_123795_), xPos, yPos, zPos, 0.0, -0.1, 0.0);
                            }
                        }
                    }
                    if (stackIndex != -1) {
                        ItemStack flyingStack = player.m_150109_().m_8020_(stackIndex);
                        if (flyingTicksRemaining - 1 <= 0) {
                            item = flyingStack.m_41720_();
                            flyingStack.m_41774_(1);
                            ItemStack newStack = null;
                            if (item == Items.f_42447_) {
                                newStack = new ItemStack((ItemLike)Items.f_42446_);
                            } else if (item == Items.f_42589_ && PotionUtils.m_43579_((ItemStack)flyingStack) == Potions.f_43599_) {
                                newStack = new ItemStack((ItemLike)Items.f_42590_);
                            } else if (Block.m_49814_((Item)item) == Blocks.f_50057_) {
                                newStack = new ItemStack((ItemLike)Blocks.f_50056_);
                            }
                            if (newStack != null) {
                                if (flyingStack.m_41619_()) {
                                    player.m_150109_().m_6836_(stackIndex, newStack);
                                } else if (!player.m_150109_().m_36054_(newStack)) {
                                    player.m_36176_(newStack, false);
                                }
                                flyingStack.m_41784_().m_128473_("FinsFlyingTicks");
                            }
                        } else {
                            CompoundTag tag = flyingStack.m_41784_();
                            tag.m_128405_("FinsFlyingTicks", tag.m_128451_("FinsFlyingTicks") + 1);
                        }
                    }
                }
            }
        }
    }

    public void m_7373_(ItemStack p_77624_1_, @Nullable Level p_77624_2_, List<Component> p_77624_3_, TooltipFlag p_77624_4_) {
        super.m_7373_(p_77624_1_, p_77624_2_, p_77624_3_, p_77624_4_);
        p_77624_3_.add((Component)Component.m_237115_((String)"finsandtails.gopjet_jetpack.desc").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment != Enchantments.f_44986_ && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

