/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common.entities;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import teamdraco.finsandstails.common.entities.RedBullCrabEntity;
import teamdraco.finsandstails.registry.FTItems;
import teamdraco.finsandstails.registry.FTSounds;

public class WhiteBullCrabEntity
extends WaterAnimal
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(WhiteBullCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public WhiteBullCrabEntity(EntityType<? extends WhiteBullCrabEntity> type, Level world) {
        super(type, world);
        this.f_21342_ = new MoveHelperController(this);
    }

    public float m_274421_() {
        return 1.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, RedBullCrabEntity.class, 8.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected PathNavigation m_6037_(Level world) {
        return new GroundPathNavigation((Mob)this, world);
    }

    protected float m_6108_() {
        return 0.9f;
    }

    protected ItemStack getFishBucket() {
        return new ItemStack((ItemLike)FTItems.WHITE_BULL_CRAB_BUCKET.get());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 1.0);
    }

    public void m_8119_() {
        super.m_8119_();
        List list = this.m_9236_().m_45976_(WhiteBullCrabEntity.class, this.m_20191_().m_82400_(20.0));
        if (list.size() >= 8) {
            for (WhiteBullCrabEntity crab : list) {
                crab.m_6710_((LivingEntity)list.get(this.f_19796_.m_188503_(list.size())));
            }
        }
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12529_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)FTSounds.CRAB_DEATH.get();
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12528_;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)FTItems.WHITE_BULL_CRAB_SPAWN_EGG.get());
    }

    protected void m_6229_(int p_209207_1_) {
    }

    public boolean m_8023_() {
        return !this.isFromBucket();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    public int m_5792_() {
        return 4;
    }

    private boolean isFromBucket() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void setFromBucket(boolean p_203706_1_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_203706_1_);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("FromBucket", this.isFromBucket());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFromBucket(compound.m_128471_("FromBucket"));
    }

    protected InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.m_21120_(p_230254_2_);
        if (itemstack.m_41720_() == Items.f_42447_ && this.m_6084_()) {
            this.m_5496_(SoundEvents.f_11782_, 1.0f, 1.0f);
            itemstack.m_41774_(1);
            ItemStack itemstack1 = this.getFishBucket();
            this.setBucketData(itemstack1);
            if (!this.m_9236_().f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)p_230254_1_, itemstack1);
            }
            if (itemstack.m_41619_()) {
                p_230254_1_.m_21008_(p_230254_2_, itemstack1);
            } else if (!p_230254_1_.m_150109_().m_36054_(itemstack1)) {
                p_230254_1_.m_36176_(itemstack1, false);
            }
            this.m_146870_();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(p_230254_1_, p_230254_2_);
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.bullcrab.walk"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.bullcrab.idle"));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    static class MoveHelperController
    extends MoveControl {
        private final WhiteBullCrabEntity crab;

        MoveHelperController(WhiteBullCrabEntity crab) {
            super((Mob)crab);
            this.crab = crab;
        }

        public void m_8126_() {
            if (this.crab.m_204029_(FluidTags.f_13131_)) {
                this.crab.m_20256_(this.crab.m_20184_().m_82520_(0.0, 0.0, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.crab.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.crab.m_20185_();
                double d1 = this.f_24976_ - this.crab.m_20186_();
                double d2 = this.f_24977_ - this.crab.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.crab.m_146922_(this.m_24991_(this.crab.m_146908_(), f, 90.0f));
                this.crab.f_20883_ = this.crab.m_146908_();
                float f1 = (float)(this.f_24978_ * this.crab.m_21133_(Attributes.f_22279_));
                this.crab.m_7910_(Mth.m_14179_((float)0.125f, (float)this.crab.m_6113_(), (float)f1));
                this.crab.m_20256_(this.crab.m_20184_().m_82520_(0.0, (double)this.crab.m_6113_() * d1 * 0.1, 0.0));
            } else {
                this.crab.m_7910_(0.0f);
            }
        }
    }
}

