/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common.entities;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.Tags;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import teamdraco.finsandstails.registry.FTItems;
import teamdraco.finsandstails.registry.FTSounds;

public class SpindlyGemCrabEntity
extends AbstractFish
implements GeoEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(SpindlyGemCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SpindlyGemCrabEntity(EntityType<? extends SpindlyGemCrabEntity> type, Level world) {
        super(type, world);
        this.f_21342_ = new MoveHelperController(this);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_((TagKey)Tags.Items.GEMS), false));
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public PathNavigation m_6037_(Level world) {
        return new GroundPathNavigation((Mob)this, world);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)FTItems.SPINDLY_GEM_CRAB_BUCKET.get());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (dataTag == null) {
            this.setVariant(this.f_19796_.m_188503_(5));
        } else if (dataTag.m_128425_("Variant", 3)) {
            this.setVariant(dataTag.m_128451_("Variant"));
        }
        return spawnDataIn;
    }

    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("Variant", this.getVariant());
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    public void m_7822_(byte id) {
        if (id == 38) {
            this.shineParticles(ParticleTypes.f_123810_);
        } else {
            super.m_7822_(id);
        }
    }

    private void shineParticles(SimpleParticleType p_208401_1_) {
        if ((double)this.f_19796_.m_188501_() > 0.975) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)p_208401_1_, this.m_20185_(), this.m_20187_(), this.m_20189_(), d0, d1, d2);
        }
    }

    public static AttributeSupplier.Builder m_27495_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0);
    }

    @Nullable
    public SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12529_;
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)FTSounds.CRAB_DEATH.get();
    }

    public SoundEvent m_5699_() {
        return SoundEvents.f_12528_;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)FTItems.SPINDLY_GEM_CRAB_SPAWN_EGG.get());
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_9236_().m_7605_((Entity)this, (byte)38);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        boolean walking;
        boolean bl = walking = !(event.getLimbSwingAmount() > -0.01f) || !(event.getLimbSwingAmount() < 0.01f);
        if (walking) {
            event.setAnimation(RawAnimation.begin().thenLoop("animation.Spindly_crab.move"));
        } else {
            event.setAnimation(RawAnimation.begin().thenLoop("animation.spindly_crab.idle"));
        }
        return PlayState.CONTINUE;
    }

    static class MoveHelperController
    extends MoveControl {
        private final SpindlyGemCrabEntity crab;

        MoveHelperController(SpindlyGemCrabEntity crab) {
            super((Mob)crab);
            this.crab = crab;
        }

        public void m_8126_() {
            if (this.crab.m_204029_(FluidTags.f_13131_)) {
                this.crab.m_20256_(this.crab.m_20184_().m_82520_(0.0, 0.0, 0.0));
            }
            if (this.crab.f_19862_ && this.crab.m_9236_().m_8055_(this.crab.m_20183_().m_7494_()).m_60734_() == Blocks.f_49990_) {
                this.crab.m_20256_(this.crab.m_20184_().m_82520_(0.0, 0.025, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.crab.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.crab.m_20185_();
                double d1 = this.f_24976_ - this.crab.m_20186_();
                double d2 = this.f_24977_ - this.crab.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.crab.m_146922_(this.m_24991_(this.crab.m_146908_(), f, 90.0f));
                this.crab.f_20883_ = this.crab.m_146908_();
                float f1 = (float)(this.f_24978_ * this.crab.m_21133_(Attributes.f_22279_));
                this.crab.m_7910_(Mth.m_14179_((float)0.125f, (float)this.crab.m_6113_(), (float)f1));
                this.crab.m_20256_(this.crab.m_20184_().m_82520_(0.0, (double)this.crab.m_6113_() * d1 * 0.1, 0.0));
            } else {
                this.crab.m_7910_(0.0f);
            }
        }
    }
}

