/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common.entities;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import teamdraco.finsandstails.registry.FTEntities;
import teamdraco.finsandstails.registry.FTItems;

public class RiverPebbleSnailEntity
extends Animal
implements GeoEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(RiverPebbleSnailEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_SHIMMER = SynchedEntityData.m_135353_(RiverPebbleSnailEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int shimmerTime = 20;
    public int shimmerCooldown = this.f_19796_.m_188503_(100) + 200;

    public RiverPebbleSnailEntity(EntityType<? extends RiverPebbleSnailEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MoveHelperController(this);
    }

    public float getStepHeight() {
        return 1.0f;
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41952_}), false));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_30232_() {
        super.m_30232_();
        if (!this.m_6162_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_20000_((ItemLike)FTItems.PEBBLE_SHELL.get(), 1);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.15);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.getVariant() == 5) {
            if (--this.shimmerCooldown <= 0) {
                this.m_5496_(SoundEvents.f_276532_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.shimmerCooldown = this.f_19796_.m_188503_(100) + 200;
                this.setShimmer(true);
                this.shimmerTime = 20;
            }
            if (--this.shimmerTime <= 0) {
                this.setShimmer(false);
                this.shimmerTime = 0;
            }
        }
    }

    public SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11761_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_11759_;
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11856_, 0.15f, 1.0f);
    }

    public float m_6121_() {
        return 0.4f;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        RiverPebbleSnailEntity snail = (RiverPebbleSnailEntity)((EntityType)FTEntities.RIVER_PEBBLE_SNAIL.get()).m_20615_((Level)world);
        if (ageable instanceof RiverPebbleSnailEntity) {
            snail.setVariant(this.f_19796_.m_188503_(5));
        }
        return snail;
    }

    public float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.25f;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)FTItems.RIVER_PEBBLE_SNAIL_SPAWN_EGG.get());
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_41952_;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() == Items.f_42618_ && this.m_6084_() && !this.m_6162_()) {
            this.m_5496_(SoundEvents.f_12013_, 1.0f, 1.0f);
            heldItem.m_41774_(1);
            ItemStack itemstack1 = new ItemStack((ItemLike)FTItems.RIVER_PEBBLE_SNAIL_POT.get());
            this.setBucketData(itemstack1);
            if (!this.m_9236_().f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, itemstack1);
                heldItem.m_41784_().m_128405_("Age", this.m_146764_());
            }
            if (heldItem.m_41619_()) {
                player.m_21008_(hand, itemstack1);
            } else if (!player.m_150109_().m_36054_(itemstack1)) {
                player.m_36176_(itemstack1, false);
            }
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void setBucketData(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("Variant", this.getVariant());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (dataTag == null) {
            if (this.f_19796_.m_188501_() > 0.95f) {
                this.setVariant(5);
            } else {
                this.setVariant(this.f_19796_.m_188503_(5));
            }
        } else if (dataTag.m_128425_("Variant", 3)) {
            this.setVariant(dataTag.m_128451_("Variant"));
        }
        return spawnDataIn;
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(IS_SHIMMER, (Object)false);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    private void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public boolean getShimmer() {
        return (Boolean)this.f_19804_.m_135370_(IS_SHIMMER);
    }

    private void setShimmer(boolean shimmer) {
        this.f_19804_.m_135381_(IS_SHIMMER, (Object)shimmer);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    public PathNavigation m_6037_(Level world) {
        return new GroundPathNavigation((Mob)this, world);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "shimmer_controller", 5, this::shimmerPredicate)});
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        if (event.isMoving()) {
            event.setAnimation(RawAnimation.begin().thenLoop("animation.snail.walk"));
        } else {
            event.setAnimation(RawAnimation.begin().thenLoop("animation.snail.idle"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends GeoEntity> PlayState shimmerPredicate(AnimationState<E> event) {
        if (this.getVariant() == 5 && this.getShimmer()) {
            event.setAnimation(RawAnimation.begin().thenPlay("animation.snail.shimmer"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    protected float m_6108_() {
        return 5.0E-5f;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    static class MoveHelperController
    extends MoveControl {
        private final RiverPebbleSnailEntity snail;

        MoveHelperController(RiverPebbleSnailEntity snail) {
            super((Mob)snail);
            this.snail = snail;
        }

        public void m_8126_() {
            if (this.snail.f_19862_ && this.snail.m_9236_().m_8055_(this.snail.m_20183_().m_7494_()).m_60734_() == Blocks.f_49990_) {
                this.snail.m_20256_(this.snail.m_20184_().m_82520_(0.0, 0.025, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.snail.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.snail.m_20185_();
                double d1 = this.f_24976_ - this.snail.m_20186_();
                double d2 = this.f_24977_ - this.snail.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.snail.m_146922_(this.m_24991_(this.snail.m_146908_(), f, 90.0f));
                this.snail.f_20883_ = this.snail.m_146908_();
                float f1 = (float)(this.f_24978_ * this.snail.m_21133_(Attributes.f_22279_));
                if (this.snail.m_20069_()) {
                    float speedMod = 5.0f;
                    f1 *= speedMod;
                }
                this.snail.m_7910_(Mth.m_14179_((float)0.125f, (float)this.snail.m_6113_(), (float)f1));
                this.snail.m_20256_(this.snail.m_20184_().m_82520_(0.0, (double)this.snail.m_6113_() * d1 * 0.1, 0.0));
            } else {
                this.snail.m_7910_(0.0f);
            }
        }
    }
}

