/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common.entities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import teamdraco.finsandstails.common.entities.RedBullCrabEntity;
import teamdraco.finsandstails.common.entities.SpindlyGemCrabEntity;
import teamdraco.finsandstails.common.entities.WhiteBullCrabEntity;
import teamdraco.finsandstails.common.entities.ai.IHydrate;
import teamdraco.finsandstails.common.entities.ai.control.SmoothWalkGroundAndSwimMoveControl;
import teamdraco.finsandstails.common.entities.ai.goals.ShareTheBubbleGoal;
import teamdraco.finsandstails.common.entities.ai.goals.SwimWithoutGroundGoal;
import teamdraco.finsandstails.common.entities.ai.goals.WalkWithGroundGoal;
import teamdraco.finsandstails.registry.FTEntities;
import teamdraco.finsandstails.registry.FTItems;
import teamdraco.finsandstails.registry.FTSounds;

public class CrownedHorateeEntity
extends Animal
implements GeoEntity,
IHydrate,
Bucketable {
    private static final EntityDataAccessor<Boolean> HAS_BABY = SynchedEntityData.m_135353_(CrownedHorateeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BUBBLE_CHARGE = SynchedEntityData.m_135353_(CrownedHorateeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_0 = SynchedEntityData.m_135353_(CrownedHorateeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_1 = SynchedEntityData.m_135353_(CrownedHorateeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> BUBBLE_TARGET = SynchedEntityData.m_135353_(CrownedHorateeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(CrownedHorateeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41868_});

    public CrownedHorateeEntity(EntityType<? extends CrownedHorateeEntity> p_27523_, Level p_27524_) {
        super(p_27523_, p_27524_);
        this.f_21342_ = new SmoothWalkGroundAndSwimMoveControl((Mob)this, 85, 10, 0.5f, 1.0f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.m_21553_(true);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public float m_274421_() {
        return 1.0f;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6914_(LevelReader p_30348_) {
        return p_30348_.m_45784_((Entity)this);
    }

    public int m_8100_() {
        return 120;
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    public boolean m_6063_() {
        return false;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.15, true));
        this.f_21345_.m_25352_(2, (Goal)new CrownedBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LayBabyGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, (double)0.85f, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(6, (Goal)new ShareTheBubbleGoal(this, 1.0, 10));
        this.f_21345_.m_25352_(7, (Goal)new GoToWaterGoal(this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new SwimWithoutGroundGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(9, (Goal)new WalkWithGroundGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, new BabyTargetGoal<RedBullCrabEntity>((Mob)this, RedBullCrabEntity.class));
        this.f_21346_.m_25352_(1, new BabyTargetGoal<SpindlyGemCrabEntity>((Mob)this, SpindlyGemCrabEntity.class));
        this.f_21346_.m_25352_(1, new BabyTargetGoal<WhiteBullCrabEntity>((Mob)this, WhiteBullCrabEntity.class));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_BABY, (Object)false);
        this.f_19804_.m_135372_(BUBBLE_CHARGE, (Object)false);
        this.f_19804_.m_135372_(DATA_TRUSTED_ID_0, Optional.empty());
        this.f_19804_.m_135372_(DATA_TRUSTED_ID_1, Optional.empty());
        this.f_19804_.m_135372_(BUBBLE_TARGET, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    public void setBubbleTarget(int p_32818_) {
        this.f_19804_.m_135381_(BUBBLE_TARGET, (Object)p_32818_);
    }

    public boolean hasBubbleTarget() {
        return (Integer)this.f_19804_.m_135370_(BUBBLE_TARGET) != 0;
    }

    @org.jetbrains.annotations.Nullable
    public Entity getBubbleTarget() {
        return this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(BUBBLE_TARGET)).intValue());
    }

    public List<UUID> getTrustedUUIDs() {
        ArrayList list = Lists.newArrayList();
        list.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).orElse(null));
        list.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_1)).orElse(null));
        return list;
    }

    public void addTrustedUUID(@org.jetbrains.annotations.Nullable UUID p_28516_) {
        if (((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).isPresent()) {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_1, Optional.ofNullable(p_28516_));
        } else {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_0, Optional.ofNullable(p_28516_));
        }
    }

    public boolean trusts(UUID p_28530_) {
        return this.getTrustedUUIDs().contains(p_28530_);
    }

    public boolean hasBaby() {
        return (Boolean)this.f_19804_.m_135370_(HAS_BABY);
    }

    public void setHasBaby(boolean p_30235_) {
        this.f_19804_.m_135381_(HAS_BABY, (Object)p_30235_);
    }

    public boolean isBubbleCharge() {
        return (Boolean)this.f_19804_.m_135370_(BUBBLE_CHARGE);
    }

    public void setBubbleCharge(boolean p_30235_) {
        this.f_19804_.m_135381_(BUBBLE_CHARGE, (Object)p_30235_);
    }

    public boolean m_6779_(LivingEntity p_21171_) {
        return !this.trusts(p_21171_.m_20148_()) && super.m_6779_(p_21171_);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isBubbleCharge() && this.hasBubbleTarget() && this.getBubbleTarget() != null) {
            for (int i = 0; i < 3; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20188_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, (this.getBubbleTarget().m_20185_() - (this.m_20185_() + this.m_20154_().f_82479_ / 2.0)) * (double)0.95f, (this.getBubbleTarget().m_20188_() - this.m_20188_()) * (double)0.95f, (this.getBubbleTarget().m_20189_() - (this.m_20189_() + this.m_20154_().f_82481_ / 2.0)) * (double)0.95f);
            }
        }
    }

    public boolean m_6898_(ItemStack p_27600_) {
        return FOOD_ITEMS.test(p_27600_);
    }

    public InteractionResult m_6071_(Player p_28153_, InteractionHand p_28154_) {
        ItemStack itemstack = p_28153_.m_21120_(p_28154_);
        Item item = itemstack.m_41720_();
        if (this.trusts(p_28153_.m_20148_()) && this.m_6898_(itemstack)) {
            this.m_5634_(2.0f);
            itemstack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (this.m_6162_()) {
            return Bucketable.m_148828_((Player)p_28153_, (InteractionHand)p_28154_, (LivingEntity)this).orElse(super.m_6071_(p_28153_, p_28154_));
        }
        return super.m_6071_(p_28153_, p_28154_);
    }

    public void m_7380_(CompoundTag p_30176_) {
        super.m_7380_(p_30176_);
        p_30176_.m_128379_("HasBaby", this.hasBaby());
        List<UUID> list = this.getTrustedUUIDs();
        ListTag listtag = new ListTag();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            listtag.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        p_30176_.m_128365_("Trusted", (Tag)listtag);
    }

    public void m_7378_(CompoundTag p_30162_) {
        super.m_7378_(p_30162_);
        this.setHasBaby(p_30162_.m_128471_("HasBaby"));
        ListTag listtag = p_30162_.m_128437_("Trusted", 11);
        for (int i = 0; i < listtag.size(); ++i) {
            this.addTrustedUUID(NbtUtils.m_129233_((Tag)listtag.get(i)));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 3.0);
    }

    public float m_5610_(BlockPos p_30159_, LevelReader p_30160_) {
        return CrownedHorateeEntity.onSandOrGravel((BlockGetter)p_30160_, p_30159_) ? 10.0f + p_30160_.m_220417_(p_30159_) - 0.5f : p_30160_.m_220417_(p_30159_) - 0.5f;
    }

    public static boolean checkCrownedSpawnRules(EntityType<? extends CrownedHorateeEntity> p_30179_, LevelAccessor p_30180_, MobSpawnType p_30181_, BlockPos p_30182_, RandomSource p_30183_) {
        return p_30182_.m_123342_() < p_30180_.m_5736_() + 4 && CrownedHorateeEntity.onSandOrGravel((BlockGetter)p_30180_, p_30182_) && CrownedHorateeEntity.m_186209_((BlockAndTintGetter)p_30180_, (BlockPos)p_30182_);
    }

    public static boolean onSandOrGravel(BlockGetter p_57763_, BlockPos p_57764_) {
        return CrownedHorateeEntity.isSandOrGravel(p_57763_, p_57764_.m_7495_());
    }

    public static boolean isSandOrGravel(BlockGetter p_57801_, BlockPos p_57802_) {
        return p_57801_.m_8055_(p_57802_).m_204336_(BlockTags.f_13029_) || p_57801_.m_8055_(p_57802_).m_204336_(Tags.Blocks.GRAVEL);
    }

    public void m_7023_(Vec3 p_27490_) {
        if (this.m_21515_() && this.m_20069_() && !this.m_20096_()) {
            this.m_19920_(0.05f, p_27490_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(p_27490_);
        }
    }

    protected PathNavigation m_6037_(Level worldIn) {
        GroundPathNavigation groundPathNavigation = new GroundPathNavigation((Mob)this, this.m_9236_());
        groundPathNavigation.m_7008_(false);
        return groundPathNavigation;
    }

    public boolean m_6040_() {
        return true;
    }

    protected void handleAirSupply(int p_149194_) {
        if (this.m_6084_() && !this.m_20071_() && !this.m_6162_()) {
            this.m_20301_(p_149194_ - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_9236_().m_269111_().m_269483_(), 2.0f);
            }
        } else {
            this.m_20301_(this.m_6062_());
        }
    }

    @Override
    public void rehydrate() {
        int i = this.m_20146_() + 1200;
        this.m_20301_(Math.min(i, this.m_6062_()));
    }

    public int m_6062_() {
        return 6000;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "miscController", 0, this::miscPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public boolean m_6785_(double p_21542_) {
        return false;
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)FTSounds.HORATEE_AMBIENT.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)FTSounds.HORATEE_HURT.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)FTSounds.HORATEE_DEATH.get();
    }

    private <E extends GeoAnimatable> PlayState miscPredicate(AnimationState<E> event) {
        if (!this.isBubbleCharge()) {
            return PlayState.STOP;
        }
        event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.model.bubble"));
        return PlayState.CONTINUE;
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        float f = 1.0f;
        if (this.m_6162_()) {
            f += 0.5f;
        }
        if (event.getLimbSwingAmount() > 0.01f) {
            if (this.m_20069_()) {
                if (this.m_20096_()) {
                    f += 0.25f;
                    event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.model.walk"));
                } else {
                    event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.model.swim"));
                }
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.model.crawl"));
            }
        } else if (this.m_20069_()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.model.idle_water"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.model.idle_land"));
        }
        event.getController().setAnimationSpeed((double)f);
        return PlayState.CONTINUE;
    }

    @org.jetbrains.annotations.Nullable
    public CrownedHorateeEntity getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_) {
        return (CrownedHorateeEntity)((EntityType)FTEntities.CROWNED_HORATTE.get()).m_20615_((Level)p_146743_);
    }

    public boolean m_5957_() {
        return super.m_5957_() && !this.hasBaby();
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean p_149196_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_149196_);
    }

    public void m_6872_(ItemStack p_27494_) {
        Bucketable.m_148822_((Mob)this, (ItemStack)p_27494_);
        CompoundTag compoundtag = p_27494_.m_41784_();
        compoundtag.m_128405_("Age", this.m_146764_());
        List<UUID> list = this.getTrustedUUIDs();
        ListTag listtag = new ListTag();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            listtag.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        compoundtag.m_128365_("Trusted", (Tag)listtag);
    }

    public void m_142278_(CompoundTag p_148708_) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)p_148708_);
        if (p_148708_.m_128441_("Age")) {
            this.m_146762_(p_148708_.m_128451_("Age"));
        }
        if (p_148708_.m_128441_("Trusted")) {
            ListTag listtag = p_148708_.m_128437_("Trusted", 11);
            for (int i = 0; i < listtag.size(); ++i) {
                this.addTrustedUUID(NbtUtils.m_129233_((Tag)listtag.get(i)));
            }
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @org.jetbrains.annotations.Nullable SpawnGroupData p_146749_, @org.jetbrains.annotations.Nullable CompoundTag p_146750_) {
        if (p_146748_ == MobSpawnType.BUCKET && p_146750_ != null && p_146750_.m_128425_("Age", 3)) {
            this.m_146762_(p_146750_.m_128451_("Age"));
            return p_146749_;
        }
        if (p_146748_ == MobSpawnType.BUCKET) {
            this.m_6863_(true);
            return p_146749_;
        }
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    public ItemStack m_28282_() {
        return ((Item)FTItems.BABY_HORATEE_BUCKET.get()).m_7968_();
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    static class CrownedBreedGoal
    extends BreedGoal {
        private final CrownedHorateeEntity crownedHorateeEntity;

        CrownedBreedGoal(CrownedHorateeEntity p_30244_, double p_30245_) {
            super((Animal)p_30244_, p_30245_);
            this.crownedHorateeEntity = p_30244_;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.crownedHorateeEntity.hasBaby();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.crownedHorateeEntity.hasBaby();
        }

        protected void m_8026_() {
            ServerPlayer serverplayer = this.f_25113_.m_27592_();
            if (serverplayer == null && this.f_25115_.m_27592_() != null) {
                serverplayer = this.f_25115_.m_27592_();
            }
            if (serverplayer != null) {
                serverplayer.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverplayer, this.f_25113_, this.f_25115_, null);
            }
            this.f_25114_.m_7605_((Entity)this.f_25113_, (byte)18);
            this.crownedHorateeEntity.m_146762_(6000);
            this.f_25115_.m_146762_(6000);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
            this.crownedHorateeEntity.setHasBaby(true);
        }
    }

    static class LayBabyGoal
    extends MoveToBlockGoal {
        private final CrownedHorateeEntity crownedHorateeEntity;
        private int layCounter;

        LayBabyGoal(CrownedHorateeEntity p_30276_, double p_30277_) {
            super((PathfinderMob)p_30276_, p_30277_, 16);
            this.crownedHorateeEntity = p_30276_;
        }

        public boolean m_8036_() {
            return this.crownedHorateeEntity.hasBaby() ? super.m_8036_() : false;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.crownedHorateeEntity.hasBaby();
        }

        public void m_8056_() {
            super.m_8056_();
            this.layCounter = 0;
        }

        public void m_8037_() {
            super.m_8037_();
            if (!this.crownedHorateeEntity.m_20069_() && this.m_25625_() && ++this.layCounter == this.m_183277_(1)) {
                Level level = this.crownedHorateeEntity.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    CrownedHorateeEntity ageablemob = this.crownedHorateeEntity.getBreedOffspring(serverLevel, (AgeableMob)this.crownedHorateeEntity);
                    ageablemob.m_6863_(true);
                    ServerPlayer serverplayer = this.crownedHorateeEntity.m_27592_();
                    if (serverplayer != null) {
                        ageablemob.addTrustedUUID(serverplayer.m_20148_());
                    }
                    ageablemob.m_7678_(this.crownedHorateeEntity.m_20185_(), this.crownedHorateeEntity.m_20186_(), this.crownedHorateeEntity.m_20189_(), 0.0f, 0.0f);
                    serverLevel.m_47205_((Entity)ageablemob);
                    serverLevel.m_7605_((Entity)this.crownedHorateeEntity, (byte)18);
                    if (serverLevel.m_46469_().m_46207_(GameRules.f_46135_)) {
                        serverLevel.m_7967_((Entity)new ExperienceOrb((Level)serverLevel, this.crownedHorateeEntity.m_20185_(), this.crownedHorateeEntity.m_20186_(), this.crownedHorateeEntity.m_20189_(), this.crownedHorateeEntity.m_217043_().m_188503_(7) + 1));
                    }
                }
                this.crownedHorateeEntity.setHasBaby(false);
            }
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            return (level.m_46859_(pos.m_7494_()) || !level.m_46859_(pos) || !level.m_6425_(pos).m_76178_()) && CrownedHorateeEntity.onSandOrGravel((BlockGetter)level, pos);
        }
    }

    static class GoToWaterGoal
    extends Goal {
        private final CrownedHorateeEntity mob;
        private double wantedX;
        private double wantedY;
        private double wantedZ;
        private final double speedModifier;
        private final Level level;

        public GoToWaterGoal(CrownedHorateeEntity p_32425_, double p_32426_) {
            this.mob = p_32425_;
            this.speedModifier = p_32426_;
            this.level = p_32425_.m_9236_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.mob.m_20146_() > 1200) {
                return false;
            }
            if (this.mob.m_20069_()) {
                return false;
            }
            Vec3 vec3 = this.getWaterPos();
            if (vec3 == null) {
                return false;
            }
            this.wantedX = vec3.f_82479_;
            this.wantedY = vec3.f_82480_;
            this.wantedZ = vec3.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            return !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }

        @Nullable
        private Vec3 getWaterPos() {
            RandomSource random = this.mob.m_217043_();
            BlockPos blockpos = this.mob.m_20183_();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(random.m_188503_(20) - 10, 2 - random.m_188503_(8), random.m_188503_(20) - 10);
                if (!this.level.m_8055_(blockpos1).m_60713_(Blocks.f_49990_)) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }

    static class BabyTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public BabyTargetGoal(Mob p_26060_, Class<T> p_26061_) {
            super(p_26060_, p_26061_, true);
        }

        public boolean m_8036_() {
            return !this.f_26135_.m_6162_() ? false : super.m_8036_();
        }
    }
}

