/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import teamdraco.finsandstails.registry.FTBlocks;
import teamdraco.finsandstails.registry.FTRecipes;

public class CrunchingRecipe
implements Recipe<Container> {
    public static final Serializer SERIALIZER = new Serializer();
    private final Ingredient base;
    private final Ingredient addition;
    private final ItemStack result;
    private final ResourceLocation recipeId;

    public CrunchingRecipe(ResourceLocation recipeId, Ingredient base, Ingredient addition, ItemStack result) {
        this.recipeId = recipeId;
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.base.test(inv.m_8020_(0)) && this.addition.test(inv.m_8020_(1));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)FTBlocks.CRAB_CRUNCHER.get());
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FTRecipes.CRUNCHING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)FTRecipes.CRUNCHING_TYPE.get();
    }

    public boolean isAdditionIngredient(ItemStack p_44536_) {
        return this.addition.test(p_44536_);
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList i = NonNullList.m_122779_();
        i.add((Object)this.base);
        i.add((Object)this.addition);
        i.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)((Block)FTBlocks.CRAB_CRUNCHER.get()).m_5456_())}));
        return i;
    }

    public static class Serializer
    implements RecipeSerializer<CrunchingRecipe> {
        public CrunchingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"base"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"addition"));
            Item item = ShapedRecipe.m_151278_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new CrunchingRecipe(recipeId, ingredient, ingredient1, new ItemStack((ItemLike)item));
        }

        public CrunchingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack itemstack = buffer.m_130267_();
            return new CrunchingRecipe(recipeId, ingredient, ingredient1, itemstack);
        }

        public void toNetwork(FriendlyByteBuf buffer, CrunchingRecipe recipe) {
            recipe.base.m_43923_(buffer);
            recipe.addition.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
        }
    }
}

