/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.medieval_craft_weapons.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.medieval_craft_weapons.MedievalcraftweaponsMod;
import net.mcreator.medieval_craft_weapons.procedures.ASBluePrintProcedure;
import net.mcreator.medieval_craft_weapons.procedures.AxeblueprintProcedure;
import net.mcreator.medieval_craft_weapons.procedures.GreatswordBluePrintProcedure;
import net.mcreator.medieval_craft_weapons.procedures.LBluePrintPProcedure;
import net.mcreator.medieval_craft_weapons.procedures.MaceBluePrintProcedure;
import net.mcreator.medieval_craft_weapons.procedures.SpearBPProcedure;
import net.mcreator.medieval_craft_weapons.world.inventory.ProjectBenchGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ProjectBenchGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ProjectBenchGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ProjectBenchGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ProjectBenchGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ProjectBenchGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ProjectBenchGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ProjectBenchGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            LBluePrintPProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ASBluePrintProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            SpearBPProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            MaceBluePrintProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            GreatswordBluePrintProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            AxeblueprintProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MedievalcraftweaponsMod.addNetworkMessage(ProjectBenchGUIButtonMessage.class, ProjectBenchGUIButtonMessage::buffer, ProjectBenchGUIButtonMessage::new, ProjectBenchGUIButtonMessage::handler);
    }
}

