/*
 * Decompiled with CFR 0.152.
 */
package filthycoin.theorcs.common.entities.state_machines;

import filthycoin.theorcs.common.entities.BaseModEntity;
import filthycoin.theorcs.common.entities.state_machines.StateHolder;
import filthycoin.theorcs.common.entities.state_machines.transitions.StateTransition;
import java.util.HashMap;
import java.util.Optional;

public class StateMachine {
    private HashMap<String, Float> parameters = new HashMap();
    private HashMap<String, StateHolder> states = new HashMap();
    public final BaseModEntity entity;
    private String current_state;
    private boolean started = false;

    public StateMachine(BaseModEntity entity) {
        this.entity = entity;
        this.AddParameter("time_in_state", 0.0f);
    }

    public void AddParameter(String name, float value) {
        this.parameters.put(name, Float.valueOf(value));
    }

    public void SetParameter(String name, float value) {
        if (!this.parameters.containsKey(name)) {
            this.AddParameter(name, value);
            return;
        }
        this.parameters.replace(name, Float.valueOf(value));
    }

    public Optional<Float> GetParameter(String name) {
        if (this.parameters.containsKey(name)) {
            return Optional.of(this.parameters.get(name));
        }
        return Optional.empty();
    }

    public Optional<StateHolder> GetState(String name) {
        if (this.states.containsKey(name)) {
            return Optional.of(this.states.get(name));
        }
        return Optional.empty();
    }

    public void AddState(String name, StateHolder state) {
        if (!this.states.containsKey(name)) {
            this.states.put(name, state);
        }
    }

    public void SetCurrentState(String state) {
        this.current_state = state;
    }

    public void Update() {
        Optional<StateHolder> state = this.GetState(this.current_state);
        if (state.isEmpty()) {
            return;
        }
        if (!this.started) {
            this.Start();
            this.started = true;
        }
        if (this.GetParameter("time_in_state").get().floatValue() > (float)state.get().length && state.get().length > -1) {
            state.get().state.TimeLimitReached(this);
        } else {
            state.get().state.Update(this);
        }
        this.SetParameter("time_in_state", this.GetParameter("time_in_state").get().floatValue() + 1.0f);
        StateTransition[] transitions = state.get().transitions;
        for (int i = 0; i < transitions.length; ++i) {
            if (!transitions[i].OperateOn(this)) continue;
            this.End();
            this.SetCurrentState(transitions[i].next_state);
            this.Start();
            break;
        }
    }

    private void Start() {
        Optional<StateHolder> state = this.GetState(this.current_state);
        if (state.isEmpty()) {
            return;
        }
        state.get().state.Start(this);
        this.SetParameter("time_in_state", 0.0f);
    }

    private void End() {
        Optional<StateHolder> state = this.GetState(this.current_state);
        if (state.isEmpty()) {
            return;
        }
        state.get().state.End(this);
    }
}

