/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ResourceConfigValue;
import dev.ftb.mods.ftblibrary.config.ui.SelectItemStackScreen;
import dev.ftb.mods.ftblibrary.config.ui.SelectableResource;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import java.util.OptionalLong;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class ItemStackConfig
extends ResourceConfigValue<ItemStack> {
    private final boolean allowEmpty;
    private final boolean isFixedSize;
    private final long fixedSize;

    public ItemStackConfig(boolean single, boolean empty) {
        this.isFixedSize = single && !empty;
        this.fixedSize = 0L;
        this.allowEmpty = empty;
        this.defaultValue = ItemStack.f_41583_;
        this.value = ItemStack.f_41583_;
    }

    public ItemStackConfig(long fixedSize) {
        Validate.isTrue((fixedSize >= 1L ? 1 : 0) != 0);
        this.isFixedSize = true;
        this.fixedSize = fixedSize;
        this.allowEmpty = false;
        this.defaultValue = ItemStack.f_41583_;
        this.value = ItemStack.f_41583_;
    }

    @Override
    public ItemStack copy(ItemStack value) {
        return value.m_41619_() ? ItemStack.f_41583_ : value.m_41777_();
    }

    @Override
    public Component getStringForGUI(@Nullable ItemStack v) {
        if (v == null || v.m_41619_()) {
            return Component.m_237115_((String)"gui.none");
        }
        if (v.m_41613_() <= 1) {
            return v.m_41786_();
        }
        return Component.m_237113_((String)(v.m_41613_() + "x ")).m_7220_(v.m_41786_());
    }

    @Override
    public void onClicked(Widget clickedWidget, MouseButton button, ConfigCallback callback) {
        if (this.getCanEdit()) {
            new SelectItemStackScreen(this, callback).openGui();
        }
    }

    @Override
    public ItemStack getValue() {
        ItemStack val = (ItemStack)super.getValue();
        return val.m_41619_() ? ItemStack.f_41583_ : val;
    }

    @Override
    public boolean allowEmptyResource() {
        return this.allowEmpty;
    }

    @Override
    public OptionalLong fixedResourceSize() {
        return this.isFixedSize ? OptionalLong.of(this.fixedSize) : OptionalLong.empty();
    }

    @Override
    public boolean isEmpty() {
        return this.getValue().m_41619_();
    }

    @Override
    public SelectableResource<ItemStack> getResource() {
        return SelectableResource.item(this.getValue());
    }

    @Override
    public boolean setResource(SelectableResource<ItemStack> selectedStack) {
        return this.setCurrentValue(selectedStack.stack());
    }
}

